@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Response for checking user's role for Logz.io account.
 * @property role User roles on configured in Logz.io account.
 */
public data class UserRoleResponseResponse(
    public val role: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.UserRoleResponseResponse):
            UserRoleResponseResponse = UserRoleResponseResponse(
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
        )
    }
}
