@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.m365securityandcompliance.kotlin

import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.m365securityandcompliance.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionsForEDM].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionsForEDMResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionsForEDMArgs = PrivateEndpointConnectionsForEDMArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointConnectionsForEDMArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionsForEDMArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionsForEDM {
        val builtJavaResource =
            com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForEDM(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionsForEDM(builtJavaResource)
    }
}

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2021-03-25-preview. Prior API version in Azure Native 1.x: 2021-03-25-preview.
 * ## Example Usage
 * ### PrivateEndpointConnection_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionsForEDM = new AzureNative.M365SecurityAndCompliance.PrivateEndpointConnectionsForEDM("privateEndpointConnectionsForEDM", new()
 *     {
 *         PrivateEndpointConnectionName = "myConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.M365SecurityAndCompliance.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Auto-Approved",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "rgname",
 *         ResourceName = "service1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/m365securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m365securityandcompliance.NewPrivateEndpointConnectionsForEDM(ctx, "privateEndpointConnectionsForEDM", &m365securityandcompliance.PrivateEndpointConnectionsForEDMArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myConnection"),
 * 			PrivateLinkServiceConnectionState: &m365securityandcompliance.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Auto-Approved"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgname"),
 * 			ResourceName:      pulumi.String("service1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForEDM;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForEDMArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionsForEDM = new PrivateEndpointConnectionsForEDM("privateEndpointConnectionsForEDM", PrivateEndpointConnectionsForEDMArgs.builder()
 *             .privateEndpointConnectionName("myConnection")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Auto-Approved"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("rgname")
 *             .resourceName("service1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:m365securityandcompliance:PrivateEndpointConnectionsForEDM myConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.M365SecurityAndCompliance/privateLinkServicesForEDMUpload/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnectionsForEDM internal constructor(
    override val javaResource:
    com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForEDM,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionsForEDMMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Required property for system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionsForEDMMapper :
    ResourceMapper<PrivateEndpointConnectionsForEDM> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForEDM::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionsForEDM =
        PrivateEndpointConnectionsForEDM(
            javaResource as
                com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForEDM,
        )
}

/**
 * @see [PrivateEndpointConnectionsForEDM].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionsForEDM].
 */
public suspend fun privateEndpointConnectionsForEDM(
    name: String,
    block: suspend PrivateEndpointConnectionsForEDMResourceBuilder.() -> Unit,
):
    PrivateEndpointConnectionsForEDM {
    val builder = PrivateEndpointConnectionsForEDMResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionsForEDM].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionsForEDM(name: String): PrivateEndpointConnectionsForEDM {
    val builder = PrivateEndpointConnectionsForEDMResourceBuilder()
    builder.name(name)
    return builder.build()
}
