@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceAccessPolicyEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An access policy entry.
 * @property objectId An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
 */
public data class ServiceAccessPolicyEntryArgs(
    public val objectId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceAccessPolicyEntryArgs> {
    override fun toJava():
        com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceAccessPolicyEntryArgs =
        com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceAccessPolicyEntryArgs.builder()
            .objectId(objectId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceAccessPolicyEntryArgs].
 */
@PulumiTagMarker
public class ServiceAccessPolicyEntryArgsBuilder internal constructor() {
    private var objectId: Output<String>? = null

    /**
     * @param value An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
     */
    @JvmName("spynkumnckiqsura")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
     */
    @JvmName("tqvrhoikoweyaykb")
    public suspend fun objectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    internal fun build(): ServiceAccessPolicyEntryArgs = ServiceAccessPolicyEntryArgs(
        objectId = objectId ?: throw PulumiNullFieldException("objectId"),
    )
}
