@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs

import com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceCorsConfigurationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The settings for the CORS configuration of the service instance.
 * @property allowCredentials If credentials are allowed via CORS.
 * @property headers The headers to be allowed via CORS.
 * @property maxAge The max age to be allowed via CORS.
 * @property methods The methods to be allowed via CORS.
 * @property origins The origins to be allowed via CORS.
 */
public data class ServiceCorsConfigurationInfoArgs(
    public val allowCredentials: Output<Boolean>? = null,
    public val headers: Output<List<String>>? = null,
    public val maxAge: Output<Double>? = null,
    public val methods: Output<List<String>>? = null,
    public val origins: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceCorsConfigurationInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceCorsConfigurationInfoArgs =
        com.pulumi.azurenative.m365securityandcompliance.inputs.ServiceCorsConfigurationInfoArgs.builder()
            .allowCredentials(allowCredentials?.applyValue({ args0 -> args0 }))
            .headers(headers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAge(maxAge?.applyValue({ args0 -> args0 }))
            .methods(methods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .origins(origins?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ServiceCorsConfigurationInfoArgs].
 */
@PulumiTagMarker
public class ServiceCorsConfigurationInfoArgsBuilder internal constructor() {
    private var allowCredentials: Output<Boolean>? = null

    private var headers: Output<List<String>>? = null

    private var maxAge: Output<Double>? = null

    private var methods: Output<List<String>>? = null

    private var origins: Output<List<String>>? = null

    /**
     * @param value If credentials are allowed via CORS.
     */
    @JvmName("lohxljcxtanaigfp")
    public suspend fun allowCredentials(`value`: Output<Boolean>) {
        this.allowCredentials = value
    }

    /**
     * @param value The headers to be allowed via CORS.
     */
    @JvmName("paaefkgykwldnnkp")
    public suspend fun headers(`value`: Output<List<String>>) {
        this.headers = value
    }

    @JvmName("qgxftjjuqvvjblxg")
    public suspend fun headers(vararg values: Output<String>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values The headers to be allowed via CORS.
     */
    @JvmName("pbtwlousfqltwiaw")
    public suspend fun headers(values: List<Output<String>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value The max age to be allowed via CORS.
     */
    @JvmName("qiaswatvdilygvrh")
    public suspend fun maxAge(`value`: Output<Double>) {
        this.maxAge = value
    }

    /**
     * @param value The methods to be allowed via CORS.
     */
    @JvmName("dpshmnqstotvjmnp")
    public suspend fun methods(`value`: Output<List<String>>) {
        this.methods = value
    }

    @JvmName("mpufcxqefxdehuym")
    public suspend fun methods(vararg values: Output<String>) {
        this.methods = Output.all(values.asList())
    }

    /**
     * @param values The methods to be allowed via CORS.
     */
    @JvmName("nuepwxxwnbteathx")
    public suspend fun methods(values: List<Output<String>>) {
        this.methods = Output.all(values)
    }

    /**
     * @param value The origins to be allowed via CORS.
     */
    @JvmName("vuhffgqiqfnralri")
    public suspend fun origins(`value`: Output<List<String>>) {
        this.origins = value
    }

    @JvmName("gwpjyanqcoddqtha")
    public suspend fun origins(vararg values: Output<String>) {
        this.origins = Output.all(values.asList())
    }

    /**
     * @param values The origins to be allowed via CORS.
     */
    @JvmName("diculqiikwoclddv")
    public suspend fun origins(values: List<Output<String>>) {
        this.origins = Output.all(values)
    }

    /**
     * @param value If credentials are allowed via CORS.
     */
    @JvmName("voiscvfyynskrvfl")
    public suspend fun allowCredentials(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowCredentials = mapped
    }

    /**
     * @param value The headers to be allowed via CORS.
     */
    @JvmName("ufgkgvkfsjcgkmcy")
    public suspend fun headers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values The headers to be allowed via CORS.
     */
    @JvmName("ouegcsamcudpfpgh")
    public suspend fun headers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value The max age to be allowed via CORS.
     */
    @JvmName("rxktxanrprxxcrqq")
    public suspend fun maxAge(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAge = mapped
    }

    /**
     * @param value The methods to be allowed via CORS.
     */
    @JvmName("ncgboghssteenjgp")
    public suspend fun methods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methods = mapped
    }

    /**
     * @param values The methods to be allowed via CORS.
     */
    @JvmName("jllfhcaijaqrtooq")
    public suspend fun methods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.methods = mapped
    }

    /**
     * @param value The origins to be allowed via CORS.
     */
    @JvmName("tkxfcednjuglqgdw")
    public suspend fun origins(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    /**
     * @param values The origins to be allowed via CORS.
     */
    @JvmName("nvisvhsughukdwto")
    public suspend fun origins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.origins = mapped
    }

    internal fun build(): ServiceCorsConfigurationInfoArgs = ServiceCorsConfigurationInfoArgs(
        allowCredentials = allowCredentials,
        headers = headers,
        maxAge = maxAge,
        methods = methods,
        origins = origins,
    )
}
