@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin

import com.pulumi.azurenative.machinelearning.kotlin.outputs.CommitmentPlanPropertiesResponse
import com.pulumi.azurenative.machinelearning.kotlin.outputs.ResourceSkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.machinelearning.kotlin.outputs.CommitmentPlanPropertiesResponse.Companion.toKotlin as commitmentPlanPropertiesResponseToKotlin
import com.pulumi.azurenative.machinelearning.kotlin.outputs.ResourceSkuResponse.Companion.toKotlin as resourceSkuResponseToKotlin

/**
 * Builder for [CommitmentPlan].
 */
@PulumiTagMarker
public class CommitmentPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CommitmentPlanArgs = CommitmentPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CommitmentPlanArgsBuilder.() -> Unit) {
        val builder = CommitmentPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CommitmentPlan {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearning.CommitmentPlan(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CommitmentPlan(builtJavaResource)
    }
}

/**
 * An Azure ML commitment plan resource.
 * Azure REST API version: 2016-05-01-preview. Prior API version in Azure Native 1.x: 2016-05-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearning:CommitmentPlan myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}
 * ```
 */
public class CommitmentPlan internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearning.CommitmentPlan,
) : KotlinCustomResource(javaResource, CommitmentPlanMapper) {
    /**
     * An entity tag used to enforce optimistic concurrency.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The commitment plan properties.
     */
    public val properties: Output<CommitmentPlanPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                commitmentPlanPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The commitment plan SKU.
     */
    public val sku: Output<ResourceSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * User-defined tags for the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CommitmentPlanMapper : ResourceMapper<CommitmentPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearning.CommitmentPlan::class == javaResource::class

    override fun map(javaResource: Resource): CommitmentPlan = CommitmentPlan(
        javaResource as
            com.pulumi.azurenative.machinelearning.CommitmentPlan,
    )
}

/**
 * @see [CommitmentPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CommitmentPlan].
 */
public suspend fun commitmentPlan(
    name: String,
    block: suspend CommitmentPlanResourceBuilder.() -> Unit,
): CommitmentPlan {
    val builder = CommitmentPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CommitmentPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun commitmentPlan(name: String): CommitmentPlan {
    val builder = CommitmentPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
