@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin

import com.pulumi.azurenative.machinelearning.WorkspaceArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearning.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a machine learning workspace.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2016-04-01.
 * ## Example Usage
 * ### WorkspaceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.MachineLearning.Workspace("workspace", new()
 *     {
 *         Location = "West Europe",
 *         OwnerEmail = "abc@microsoft.com",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.MachineLearning.Inputs.SkuArgs
 *         {
 *             Name = "Enterprise",
 *             Tier = "Enterprise",
 *         },
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *         UserStorageAccountId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/teststorage",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearning/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearning.NewWorkspace(ctx, "workspace", &machinelearning.WorkspaceArgs{
 * 			Location:          pulumi.String("West Europe"),
 * 			OwnerEmail:        pulumi.String("abc@microsoft.com"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &machinelearning.SkuArgs{
 * 				Name: pulumi.String("Enterprise"),
 * 				Tier: pulumi.String("Enterprise"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 			UserStorageAccountId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/teststorage"),
 * 			WorkspaceName:        pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearning.Workspace;
 * import com.pulumi.azurenative.machinelearning.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .location("West Europe")
 *             .ownerEmail("abc@microsoft.com")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Enterprise"),
 *                 Map.entry("tier", "Enterprise")
 *             ))
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .userStorageAccountId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/teststorage")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearning:Workspace testworkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/workspaces/{workspaceName}
 * ```
 * @property keyVaultIdentifierId The key vault identifier used for encrypted workspaces.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property ownerEmail The email id of the owner for this workspace.
 * @property resourceGroupName The name of the resource group to which the machine learning workspace belongs.
 * @property sku The sku of the workspace.
 * @property tags The tags of the resource.
 * @property userStorageAccountId The fully qualified arm id of the storage account associated with this workspace.
 * @property workspaceName The name of the machine learning workspace.
 */
public data class WorkspaceArgs(
    public val keyVaultIdentifierId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val ownerEmail: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userStorageAccountId: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.WorkspaceArgs =
        com.pulumi.azurenative.machinelearning.WorkspaceArgs.builder()
            .keyVaultIdentifierId(keyVaultIdentifierId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .ownerEmail(ownerEmail?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userStorageAccountId(userStorageAccountId?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var keyVaultIdentifierId: Output<String>? = null

    private var location: Output<String>? = null

    private var ownerEmail: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userStorageAccountId: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The key vault identifier used for encrypted workspaces.
     */
    @JvmName("qfvvhahhgcgkthed")
    public suspend fun keyVaultIdentifierId(`value`: Output<String>) {
        this.keyVaultIdentifierId = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("xminmmbuxnqiaxbm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The email id of the owner for this workspace.
     */
    @JvmName("dqixwsgdnhopgbkf")
    public suspend fun ownerEmail(`value`: Output<String>) {
        this.ownerEmail = value
    }

    /**
     * @param value The name of the resource group to which the machine learning workspace belongs.
     */
    @JvmName("bminihadhmxqcaay")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku of the workspace.
     */
    @JvmName("gphedfhjyoovnklg")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ryavvxlucoekunyb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The fully qualified arm id of the storage account associated with this workspace.
     */
    @JvmName("atbhtjunmxtxohxd")
    public suspend fun userStorageAccountId(`value`: Output<String>) {
        this.userStorageAccountId = value
    }

    /**
     * @param value The name of the machine learning workspace.
     */
    @JvmName("aliuviclgltyqshu")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The key vault identifier used for encrypted workspaces.
     */
    @JvmName("mpflipvyvfllrolo")
    public suspend fun keyVaultIdentifierId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultIdentifierId = mapped
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("ajxafjxiommegekd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The email id of the owner for this workspace.
     */
    @JvmName("mwkimusbgcmapimo")
    public suspend fun ownerEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerEmail = mapped
    }

    /**
     * @param value The name of the resource group to which the machine learning workspace belongs.
     */
    @JvmName("adtqvyhvvplmvjbx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku of the workspace.
     */
    @JvmName("eudaedlxorolngpb")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku of the workspace.
     */
    @JvmName("dtagtnokuysdniwu")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("tggblueervyakvak")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("bstvqxudpdlwotoy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The fully qualified arm id of the storage account associated with this workspace.
     */
    @JvmName("upjnpmverqvugqdn")
    public suspend fun userStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userStorageAccountId = mapped
    }

    /**
     * @param value The name of the machine learning workspace.
     */
    @JvmName("junfrwbieyowmsdi")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        keyVaultIdentifierId = keyVaultIdentifierId,
        location = location,
        ownerEmail = ownerEmail,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        userStorageAccountId = userStorageAccountId,
        workspaceName = workspaceName,
    )
}
