@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
 */
public enum class DiagnosticsLevel(
    public val javaValue: com.pulumi.azurenative.machinelearning.enums.DiagnosticsLevel,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.enums.DiagnosticsLevel> {
    None(com.pulumi.azurenative.machinelearning.enums.DiagnosticsLevel.None),
    Error(com.pulumi.azurenative.machinelearning.enums.DiagnosticsLevel.Error),
    All(com.pulumi.azurenative.machinelearning.enums.DiagnosticsLevel.All),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearning.enums.DiagnosticsLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.enums.DiagnosticsLevel):
            DiagnosticsLevel = DiagnosticsLevel.values().first { it.javaValue == javaType }
    }
}
