@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Graph parameter's type.
 */
public enum class ParameterType(
    public val javaValue: com.pulumi.azurenative.machinelearning.enums.ParameterType,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.enums.ParameterType> {
    String(com.pulumi.azurenative.machinelearning.enums.ParameterType.String),
    Int(com.pulumi.azurenative.machinelearning.enums.ParameterType.Int),
    Float(com.pulumi.azurenative.machinelearning.enums.ParameterType.Float),
    Enumerated(com.pulumi.azurenative.machinelearning.enums.ParameterType.Enumerated),
    Script(com.pulumi.azurenative.machinelearning.enums.ParameterType.Script),
    Mode(com.pulumi.azurenative.machinelearning.enums.ParameterType.Mode),
    Credential(com.pulumi.azurenative.machinelearning.enums.ParameterType.Credential),
    Boolean(com.pulumi.azurenative.machinelearning.enums.ParameterType.Boolean),
    Double(com.pulumi.azurenative.machinelearning.enums.ParameterType.Double),
    ColumnPicker(com.pulumi.azurenative.machinelearning.enums.ParameterType.ColumnPicker),
    ParameterRange(com.pulumi.azurenative.machinelearning.enums.ParameterType.ParameterRange),
    DataGatewayName(com.pulumi.azurenative.machinelearning.enums.ParameterType.DataGatewayName),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearning.enums.ParameterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.enums.ParameterType):
            ParameterType = ParameterType.values().first { it.javaValue == javaType }
    }
}
