@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.ExampleRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Sample input data for the service's input(s).
 * @property globalParameters Sample input data for the web service's global parameters
 * @property inputs Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
 */
public data class ExampleRequestArgs(
    public val globalParameters: Output<Map<String, Any>>? = null,
    public val inputs: Output<Map<String, List<List<Any>>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.ExampleRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.ExampleRequestArgs =
        com.pulumi.azurenative.machinelearning.inputs.ExampleRequestArgs.builder()
            .globalParameters(
                globalParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .inputs(
                inputs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0.map({ args0 -> args0 })
                            }),
                        )
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ExampleRequestArgs].
 */
@PulumiTagMarker
public class ExampleRequestArgsBuilder internal constructor() {
    private var globalParameters: Output<Map<String, Any>>? = null

    private var inputs: Output<Map<String, List<List<Any>>>>? = null

    /**
     * @param value Sample input data for the web service's global parameters
     */
    @JvmName("jssknmospoyedqyr")
    public suspend fun globalParameters(`value`: Output<Map<String, Any>>) {
        this.globalParameters = value
    }

    /**
     * @param value Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
     */
    @JvmName("ksccnorhabrbifrb")
    public suspend fun inputs(`value`: Output<Map<String, List<List<Any>>>>) {
        this.inputs = value
    }

    /**
     * @param value Sample input data for the web service's global parameters
     */
    @JvmName("fiuycqnhfmsshitr")
    public suspend fun globalParameters(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalParameters = mapped
    }

    /**
     * @param values Sample input data for the web service's global parameters
     */
    @JvmName("dorroqdeihbwhkmf")
    public fun globalParameters(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.globalParameters = mapped
    }

    /**
     * @param value Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
     */
    @JvmName("gpebnhsgynclnrox")
    public suspend fun inputs(`value`: Map<String, List<List<Any>>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    /**
     * @param values Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
     */
    @JvmName("sosljhbsgxgngsis")
    public fun inputs(vararg values: Pair<String, List<List<Any>>>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputs = mapped
    }

    internal fun build(): ExampleRequestArgs = ExampleRequestArgs(
        globalParameters = globalParameters,
        inputs = inputs,
    )
}
