@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.GraphEdgeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines an edge within the web service's graph.
 * @property sourceNodeId The source graph node's identifier.
 * @property sourcePortId The identifier of the source node's port that the edge connects from.
 * @property targetNodeId The destination graph node's identifier.
 * @property targetPortId The identifier of the destination node's port that the edge connects into.
 */
public data class GraphEdgeArgs(
    public val sourceNodeId: Output<String>? = null,
    public val sourcePortId: Output<String>? = null,
    public val targetNodeId: Output<String>? = null,
    public val targetPortId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.GraphEdgeArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.GraphEdgeArgs =
        com.pulumi.azurenative.machinelearning.inputs.GraphEdgeArgs.builder()
            .sourceNodeId(sourceNodeId?.applyValue({ args0 -> args0 }))
            .sourcePortId(sourcePortId?.applyValue({ args0 -> args0 }))
            .targetNodeId(targetNodeId?.applyValue({ args0 -> args0 }))
            .targetPortId(targetPortId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GraphEdgeArgs].
 */
@PulumiTagMarker
public class GraphEdgeArgsBuilder internal constructor() {
    private var sourceNodeId: Output<String>? = null

    private var sourcePortId: Output<String>? = null

    private var targetNodeId: Output<String>? = null

    private var targetPortId: Output<String>? = null

    /**
     * @param value The source graph node's identifier.
     */
    @JvmName("hmuuwemogcmbbfko")
    public suspend fun sourceNodeId(`value`: Output<String>) {
        this.sourceNodeId = value
    }

    /**
     * @param value The identifier of the source node's port that the edge connects from.
     */
    @JvmName("ouwejvsgacdxukyi")
    public suspend fun sourcePortId(`value`: Output<String>) {
        this.sourcePortId = value
    }

    /**
     * @param value The destination graph node's identifier.
     */
    @JvmName("wdjihyjmngukcbot")
    public suspend fun targetNodeId(`value`: Output<String>) {
        this.targetNodeId = value
    }

    /**
     * @param value The identifier of the destination node's port that the edge connects into.
     */
    @JvmName("akguphkfbcmctdvb")
    public suspend fun targetPortId(`value`: Output<String>) {
        this.targetPortId = value
    }

    /**
     * @param value The source graph node's identifier.
     */
    @JvmName("laojaqyroxttrtbf")
    public suspend fun sourceNodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceNodeId = mapped
    }

    /**
     * @param value The identifier of the source node's port that the edge connects from.
     */
    @JvmName("tgelrmpbxgxxvbct")
    public suspend fun sourcePortId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortId = mapped
    }

    /**
     * @param value The destination graph node's identifier.
     */
    @JvmName("dghersntkeqgykrf")
    public suspend fun targetNodeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNodeId = mapped
    }

    /**
     * @param value The identifier of the destination node's port that the edge connects into.
     */
    @JvmName("cuxmlivgkddamdmi")
    public suspend fun targetPortId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPortId = mapped
    }

    internal fun build(): GraphEdgeArgs = GraphEdgeArgs(
        sourceNodeId = sourceNodeId,
        sourcePortId = sourcePortId,
        targetNodeId = targetNodeId,
        targetPortId = targetPortId,
    )
}
