@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Information about an asset associated with the web service.
 * @property id Asset's Id.
 * @property inputPorts Information about the asset's input ports.
 * @property locationInfo Access information for the asset.
 * @property metadata If the asset is a custom module, this holds the module's metadata.
 * @property name Asset's friendly name.
 * @property outputPorts Information about the asset's output ports.
 * @property parameters If the asset is a custom module, this holds the module's parameters.
 * @property type Asset's type.
 */
public data class AssetItemResponse(
    public val id: String? = null,
    public val inputPorts: Map<String, InputPortResponse>? = null,
    public val locationInfo: BlobLocationResponse,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val outputPorts: Map<String, OutputPortResponse>? = null,
    public val parameters: List<ModuleAssetParameterResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.AssetItemResponse):
            AssetItemResponse = AssetItemResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            inputPorts = javaType.inputPorts().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.InputPortResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            locationInfo = javaType.locationInfo().let({ args0 ->
                com.pulumi.azurenative.machinelearning.kotlin.outputs.BlobLocationResponse.Companion.toKotlin(args0)
            }),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            outputPorts = javaType.outputPorts().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.OutputPortResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.ModuleAssetParameterResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
