@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Swagger 2.0 schema for a column within the data table representing a web service input or output. See Swagger specification: http://swagger.io/specification/
 * @property enum If the data type is categorical, this provides the list of accepted categories.
 * @property format Additional format information for the data type.
 * @property type Data type of the column.
 * @property xMsIsnullable Flag indicating if the type supports null values or not.
 * @property xMsIsordered Flag indicating whether the categories are treated as an ordered set or not, if this is a categorical column.
 */
public data class ColumnSpecificationResponse(
    public val `enum`: List<Any>? = null,
    public val format: String? = null,
    public val type: String,
    public val xMsIsnullable: Boolean? = null,
    public val xMsIsordered: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.ColumnSpecificationResponse):
            ColumnSpecificationResponse = ColumnSpecificationResponse(
            `enum` = javaType.enum_().map({ args0 -> args0 }),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            xMsIsnullable = javaType.xMsIsnullable().map({ args0 -> args0 }).orElse(null),
            xMsIsordered = javaType.xMsIsordered().map({ args0 -> args0 }).orElse(null),
        )
    }
}
