@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Diagnostics settings for an Azure ML web service.
 * @property expiry Specifies the date and time when the logging will cease. If null, diagnostic collection is not time limited.
 * @property level Specifies the verbosity of the diagnostic output. Valid values are: None - disables tracing; Error - collects only error (stderr) traces; All - collects all traces (stdout and stderr).
 */
public data class DiagnosticsConfigurationResponse(
    public val expiry: String? = null,
    public val level: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.DiagnosticsConfigurationResponse):
            DiagnosticsConfigurationResponse = DiagnosticsConfigurationResponse(
            expiry = javaType.expiry().map({ args0 -> args0 }).orElse(null),
            level = javaType.level(),
        )
    }
}
