@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Sample input data for the service's input(s).
 * @property globalParameters Sample input data for the web service's global parameters
 * @property inputs Sample input data for the web service's input(s) given as an input name to sample input values matrix map.
 */
public data class ExampleRequestResponse(
    public val globalParameters: Map<String, Any>? = null,
    public val inputs: Map<String, List<List<Any>>>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.ExampleRequestResponse):
            ExampleRequestResponse = ExampleRequestResponse(
            globalParameters = javaType.globalParameters().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            inputs = javaType.inputs().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0.map({ args0 -> args0 })
                    }),
                )
            }).toMap(),
        )
    }
}
