@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Instance of an Azure ML web service resource.
 * @property id Specifies the resource ID.
 * @property location Specifies the location of the resource.
 * @property name Specifies the name of the resource.
 * @property properties Contains the property payload that describes the web service.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property type Specifies the type of the resource.
 */
public data class GetWebServiceResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: WebServicePropertiesForGraphResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.GetWebServiceResult):
            GetWebServiceResult = GetWebServiceResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.machinelearning.kotlin.outputs.WebServicePropertiesForGraphResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
