@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Workspace authorization keys for a workspace.
 * @property primaryToken Primary authorization key for this workspace.
 * @property secondaryToken Secondary authorization key for this workspace.
 */
public data class ListWorkspaceKeysResult(
    public val primaryToken: String? = null,
    public val secondaryToken: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.ListWorkspaceKeysResult):
            ListWorkspaceKeysResult = ListWorkspaceKeysResult(
            primaryToken = javaType.primaryToken().map({ args0 -> args0 }).orElse(null),
            secondaryToken = javaType.secondaryToken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
