@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Nested parameter definition.
 * @property interfaceString The interface string name for the nested parameter.
 * @property parameters The definition of the parameter.
 */
public data class ModeValueInfoResponse(
    public val interfaceString: String? = null,
    public val parameters: List<ModuleAssetParameterResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.ModeValueInfoResponse):
            ModeValueInfoResponse = ModeValueInfoResponse(
            interfaceString = javaType.interfaceString().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearning.kotlin.outputs.ModuleAssetParameterResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
