@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Web Service Parameter object for node and global parameter
 * @property certificateThumbprint If the parameter value in 'value' field is encrypted, the thumbprint of the certificate should be put here.
 * @property value The parameter value
 */
public data class WebServiceParameterResponse(
    public val certificateThumbprint: String? = null,
    public val `value`: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.WebServiceParameterResponse):
            WebServiceParameterResponse = WebServiceParameterResponse(
            certificateThumbprint = javaType.certificateThumbprint().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
