@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.AcsClusterPropertiesArgs.builder
import com.pulumi.azurenative.machinelearningcompute.kotlin.enums.AgentVMSizeTypes
import com.pulumi.azurenative.machinelearningcompute.kotlin.enums.OrchestratorType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Information about the container service backing the cluster
 * @property agentCount The number of agent nodes in the Container Service. This can be changed to scale the cluster.
 * @property agentVmSize The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes.
 * @property masterCount The number of master nodes in the container service.
 * @property orchestratorProperties Orchestrator specific properties
 * @property orchestratorType Type of orchestrator. It cannot be changed once the cluster is created.
 * @property systemServices The system services deployed to the cluster
 */
public data class AcsClusterPropertiesArgs(
    public val agentCount: Output<Int>? = null,
    public val agentVmSize: Output<Either<String, AgentVMSizeTypes>>? = null,
    public val masterCount: Output<Int>? = null,
    public val orchestratorProperties: Output<KubernetesClusterPropertiesArgs>? = null,
    public val orchestratorType: Output<Either<String, OrchestratorType>>,
    public val systemServices: Output<List<SystemServiceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.AcsClusterPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.AcsClusterPropertiesArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.AcsClusterPropertiesArgs.builder()
            .agentCount(agentCount?.applyValue({ args0 -> args0 }))
            .agentVmSize(
                agentVmSize?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .masterCount(masterCount?.applyValue({ args0 -> args0 }))
            .orchestratorProperties(
                orchestratorProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .orchestratorType(
                orchestratorType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .systemServices(
                systemServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AcsClusterPropertiesArgs].
 */
@PulumiTagMarker
public class AcsClusterPropertiesArgsBuilder internal constructor() {
    private var agentCount: Output<Int>? = null

    private var agentVmSize: Output<Either<String, AgentVMSizeTypes>>? = null

    private var masterCount: Output<Int>? = null

    private var orchestratorProperties: Output<KubernetesClusterPropertiesArgs>? = null

    private var orchestratorType: Output<Either<String, OrchestratorType>>? = null

    private var systemServices: Output<List<SystemServiceArgs>>? = null

    /**
     * @param value The number of agent nodes in the Container Service. This can be changed to scale the cluster.
     */
    @JvmName("ljyvvlugqqbbcfct")
    public suspend fun agentCount(`value`: Output<Int>) {
        this.agentCount = value
    }

    /**
     * @param value The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes.
     */
    @JvmName("pljfgulupwymahgw")
    public suspend fun agentVmSize(`value`: Output<Either<String, AgentVMSizeTypes>>) {
        this.agentVmSize = value
    }

    /**
     * @param value The number of master nodes in the container service.
     */
    @JvmName("ayigcfjxgsdtctoa")
    public suspend fun masterCount(`value`: Output<Int>) {
        this.masterCount = value
    }

    /**
     * @param value Orchestrator specific properties
     */
    @JvmName("wbdhjrwvnvyvlkys")
    public suspend fun orchestratorProperties(`value`: Output<KubernetesClusterPropertiesArgs>) {
        this.orchestratorProperties = value
    }

    /**
     * @param value Type of orchestrator. It cannot be changed once the cluster is created.
     */
    @JvmName("uainnpfggssvrtxd")
    public suspend fun orchestratorType(`value`: Output<Either<String, OrchestratorType>>) {
        this.orchestratorType = value
    }

    /**
     * @param value The system services deployed to the cluster
     */
    @JvmName("nvuxbbabnpleyppn")
    public suspend fun systemServices(`value`: Output<List<SystemServiceArgs>>) {
        this.systemServices = value
    }

    @JvmName("snijsqtcrhgmvjvx")
    public suspend fun systemServices(vararg values: Output<SystemServiceArgs>) {
        this.systemServices = Output.all(values.asList())
    }

    /**
     * @param values The system services deployed to the cluster
     */
    @JvmName("jbqvbdolljmmgiwp")
    public suspend fun systemServices(values: List<Output<SystemServiceArgs>>) {
        this.systemServices = Output.all(values)
    }

    /**
     * @param value The number of agent nodes in the Container Service. This can be changed to scale the cluster.
     */
    @JvmName("pndijchiichohrdm")
    public suspend fun agentCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentCount = mapped
    }

    /**
     * @param value The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes.
     */
    @JvmName("gaukvphpgpaunjuc")
    public suspend fun agentVmSize(`value`: Either<String, AgentVMSizeTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVmSize = mapped
    }

    /**
     * @param value The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes.
     */
    @JvmName("eiqsjvdlmvhuilxb")
    public fun agentVmSize(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AgentVMSizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentVmSize = mapped
    }

    /**
     * @param value The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes.
     */
    @JvmName("nxgylkcevlfpfqsp")
    public fun agentVmSize(`value`: AgentVMSizeTypes) {
        val toBeMapped = Either.ofRight<String, AgentVMSizeTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.agentVmSize = mapped
    }

    /**
     * @param value The number of master nodes in the container service.
     */
    @JvmName("csypdpgnmedyixni")
    public suspend fun masterCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterCount = mapped
    }

    /**
     * @param value Orchestrator specific properties
     */
    @JvmName("dytvvmoxpnoqbhow")
    public suspend fun orchestratorProperties(`value`: KubernetesClusterPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orchestratorProperties = mapped
    }

    /**
     * @param argument Orchestrator specific properties
     */
    @JvmName("hxhambnitrkbwkty")
    public suspend
    fun orchestratorProperties(argument: suspend KubernetesClusterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KubernetesClusterPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.orchestratorProperties = mapped
    }

    /**
     * @param value Type of orchestrator. It cannot be changed once the cluster is created.
     */
    @JvmName("yypsleppqtemutej")
    public suspend fun orchestratorType(`value`: Either<String, OrchestratorType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orchestratorType = mapped
    }

    /**
     * @param value Type of orchestrator. It cannot be changed once the cluster is created.
     */
    @JvmName("nygxecabhvaloeeg")
    public fun orchestratorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OrchestratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orchestratorType = mapped
    }

    /**
     * @param value Type of orchestrator. It cannot be changed once the cluster is created.
     */
    @JvmName("omgnqnefaqhetuwx")
    public fun orchestratorType(`value`: OrchestratorType) {
        val toBeMapped = Either.ofRight<String, OrchestratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orchestratorType = mapped
    }

    /**
     * @param value The system services deployed to the cluster
     */
    @JvmName("jqynmrruiuqdvqso")
    public suspend fun systemServices(`value`: List<SystemServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemServices = mapped
    }

    /**
     * @param argument The system services deployed to the cluster
     */
    @JvmName("ydfqljksaxpcxmfp")
    public suspend fun systemServices(argument: List<suspend SystemServiceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SystemServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.systemServices = mapped
    }

    /**
     * @param argument The system services deployed to the cluster
     */
    @JvmName("rjyjitqkugsmrdyi")
    public suspend fun systemServices(vararg argument: suspend SystemServiceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SystemServiceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.systemServices = mapped
    }

    /**
     * @param argument The system services deployed to the cluster
     */
    @JvmName("jfgvapddxbplsfno")
    public suspend fun systemServices(argument: suspend SystemServiceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SystemServiceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.systemServices = mapped
    }

    /**
     * @param values The system services deployed to the cluster
     */
    @JvmName("tiijrfdhtjtespet")
    public suspend fun systemServices(vararg values: SystemServiceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemServices = mapped
    }

    internal fun build(): AcsClusterPropertiesArgs = AcsClusterPropertiesArgs(
        agentCount = agentCount,
        agentVmSize = agentVmSize,
        masterCount = masterCount,
        orchestratorProperties = orchestratorProperties,
        orchestratorType = orchestratorType ?: throw PulumiNullFieldException("orchestratorType"),
        systemServices = systemServices,
    )
}
