@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.AppInsightsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of App Insights.
 * @property resourceId ARM resource ID of the App Insights.
 */
public data class AppInsightsPropertiesArgs(
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.AppInsightsPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.AppInsightsPropertiesArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.AppInsightsPropertiesArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppInsightsPropertiesArgs].
 */
@PulumiTagMarker
public class AppInsightsPropertiesArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value ARM resource ID of the App Insights.
     */
    @JvmName("htgifxvylvjuspma")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value ARM resource ID of the App Insights.
     */
    @JvmName("rodcybgpctiafwbu")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): AppInsightsPropertiesArgs = AppInsightsPropertiesArgs(
        resourceId = resourceId,
    )
}
