@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.ServicePrincipalPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Azure service principal used by Kubernetes for configuring load balancers
 * @property clientId The service principal client ID
 * @property secret The service principal secret. This is not returned in response of GET/PUT on the resource. To see this please call listKeys.
 */
public data class ServicePrincipalPropertiesArgs(
    public val clientId: Output<String>,
    public val secret: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.ServicePrincipalPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.ServicePrincipalPropertiesArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.ServicePrincipalPropertiesArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .secret(secret.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePrincipalPropertiesArgs].
 */
@PulumiTagMarker
public class ServicePrincipalPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var secret: Output<String>? = null

    /**
     * @param value The service principal client ID
     */
    @JvmName("mewctethvqxqejft")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The service principal secret. This is not returned in response of GET/PUT on the resource. To see this please call listKeys.
     */
    @JvmName("lduugxrwcaqqpyvg")
    public suspend fun secret(`value`: Output<String>) {
        this.secret = value
    }

    /**
     * @param value The service principal client ID
     */
    @JvmName("atppkikqiegaxfgv")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The service principal secret. This is not returned in response of GET/PUT on the resource. To see this please call listKeys.
     */
    @JvmName("faquemrkbohlhowj")
    public suspend fun secret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secret = mapped
    }

    internal fun build(): ServicePrincipalPropertiesArgs = ServicePrincipalPropertiesArgs(
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        secret = secret ?: throw PulumiNullFieldException("secret"),
    )
}
