@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.StorageAccountPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Storage Account.
 * @property resourceId ARM resource ID of the Azure Storage Account to store CLI specific files. If not provided one will be created. This cannot be changed once the cluster is created.
 */
public data class StorageAccountPropertiesArgs(
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.StorageAccountPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.StorageAccountPropertiesArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.StorageAccountPropertiesArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountPropertiesArgs].
 */
@PulumiTagMarker
public class StorageAccountPropertiesArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    /**
     * @param value ARM resource ID of the Azure Storage Account to store CLI specific files. If not provided one will be created. This cannot be changed once the cluster is created.
     */
    @JvmName("eincntxgyhawshkx")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value ARM resource ID of the Azure Storage Account to store CLI specific files. If not provided one will be created. This cannot be changed once the cluster is created.
     */
    @JvmName("pegeyrljfahrxomt")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): StorageAccountPropertiesArgs = StorageAccountPropertiesArgs(
        resourceId = resourceId,
    )
}
