@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Information about the container service backing the cluster
 * @property agentCount The number of agent nodes in the Container Service. This can be changed to scale the cluster.
 * @property agentVmSize The Azure VM size of the agent VM nodes. This cannot be changed once the cluster is created. This list is non exhaustive; refer to https://docs.microsoft.com/en-us/azure/virtual-machines/windows/sizes for the possible VM sizes.
 * @property clusterFqdn The FQDN of the cluster.
 * @property masterCount The number of master nodes in the container service.
 * @property orchestratorProperties Orchestrator specific properties
 * @property orchestratorType Type of orchestrator. It cannot be changed once the cluster is created.
 * @property systemServices The system services deployed to the cluster
 */
public data class AcsClusterPropertiesResponse(
    public val agentCount: Int? = null,
    public val agentVmSize: String? = null,
    public val clusterFqdn: String,
    public val masterCount: Int? = null,
    public val orchestratorProperties: KubernetesClusterPropertiesResponse? = null,
    public val orchestratorType: String,
    public val systemServices: List<SystemServiceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.AcsClusterPropertiesResponse):
            AcsClusterPropertiesResponse = AcsClusterPropertiesResponse(
            agentCount = javaType.agentCount().map({ args0 -> args0 }).orElse(null),
            agentVmSize = javaType.agentVmSize().map({ args0 -> args0 }).orElse(null),
            clusterFqdn = javaType.clusterFqdn(),
            masterCount = javaType.masterCount().map({ args0 -> args0 }).orElse(null),
            orchestratorProperties = javaType.orchestratorProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.KubernetesClusterPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            orchestratorType = javaType.orchestratorType(),
            systemServices = javaType.systemServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.SystemServiceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
