@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * AutoScale configuration properties.
 * @property maxReplicas The maximum number of replicas for each service.
 * @property minReplicas The minimum number of replicas for each service.
 * @property refreshPeriodInSeconds Refresh period in seconds.
 * @property status If auto-scale is enabled for all services. Each service can turn it off individually.
 * @property targetUtilization The target utilization.
 */
public data class AutoScaleConfigurationResponse(
    public val maxReplicas: Int? = null,
    public val minReplicas: Int? = null,
    public val refreshPeriodInSeconds: Int? = null,
    public val status: String? = null,
    public val targetUtilization: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.AutoScaleConfigurationResponse):
            AutoScaleConfigurationResponse = AutoScaleConfigurationResponse(
            maxReplicas = javaType.maxReplicas().map({ args0 -> args0 }).orElse(null),
            minReplicas = javaType.minReplicas().map({ args0 -> args0 }).orElse(null),
            refreshPeriodInSeconds = javaType.refreshPeriodInSeconds().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            targetUtilization = javaType.targetUtilization().map({ args0 -> args0 }).orElse(null),
        )
    }
}
