@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of Azure Container Registry.
 * @property resourceId ARM resource ID of the Azure Container Registry used to store Docker images for web services in the cluster. If not provided one will be created. This cannot be changed once the cluster is created.
 */
public data class ContainerRegistryPropertiesResponse(
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ContainerRegistryPropertiesResponse):
            ContainerRegistryPropertiesResponse = ContainerRegistryPropertiesResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
