@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Error detail information.
 * @property code Error code.
 * @property message Error message.
 */
public data class ErrorDetailResponse(
    public val code: String,
    public val message: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ErrorDetailResponse):
            ErrorDetailResponse = ErrorDetailResponse(
            code = javaType.code(),
            message = javaType.message(),
        )
    }
}
