@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.Suppress

/**
 * Kubernetes cluster specific properties
 * @property servicePrincipal The Azure Service Principal used by Kubernetes
 */
public data class KubernetesClusterPropertiesResponse(
    public val servicePrincipal: ServicePrincipalPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.KubernetesClusterPropertiesResponse):
            KubernetesClusterPropertiesResponse = KubernetesClusterPropertiesResponse(
            servicePrincipal = javaType.servicePrincipal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ServicePrincipalPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
