@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.Suppress

/**
 * Credentials to resources in the cluster.
 * @property appInsights Credentials for Azure AppInsights.
 * @property containerRegistry Credentials for Azure Container Registry.
 * @property containerService Credentials for Azure Container Service.
 * @property serviceAuthConfiguration Global authorization keys for all user services deployed in cluster. These are used if the service does not have auth keys.
 * @property sslConfiguration The SSL configuration for the services.
 * @property storageAccount Credentials for the Storage Account.
 */
public data class ListOperationalizationClusterKeysResult(
    public val appInsights: AppInsightsCredentialsResponse? = null,
    public val containerRegistry: ContainerRegistryCredentialsResponse? = null,
    public val containerService: ContainerServiceCredentialsResponse? = null,
    public val serviceAuthConfiguration: ServiceAuthConfigurationResponse? = null,
    public val sslConfiguration: SslConfigurationResponse? = null,
    public val storageAccount: StorageAccountCredentialsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ListOperationalizationClusterKeysResult):
            ListOperationalizationClusterKeysResult = ListOperationalizationClusterKeysResult(
            appInsights = javaType.appInsights().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AppInsightsCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerRegistry = javaType.containerRegistry().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ContainerRegistryCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerService = javaType.containerService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ContainerServiceCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceAuthConfiguration = javaType.serviceAuthConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ServiceAuthConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sslConfiguration = javaType.sslConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.SslConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccount = javaType.storageAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.StorageAccountCredentialsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
