@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Global service auth configuration properties. These are the data-plane authorization keys and are used if a service doesn't define it's own.
 * @property primaryAuthKeyHash The primary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
 * @property secondaryAuthKeyHash The secondary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
 */
public data class ServiceAuthConfigurationResponse(
    public val primaryAuthKeyHash: String,
    public val secondaryAuthKeyHash: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.ServiceAuthConfigurationResponse):
            ServiceAuthConfigurationResponse = ServiceAuthConfigurationResponse(
            primaryAuthKeyHash = javaType.primaryAuthKeyHash(),
            secondaryAuthKeyHash = javaType.secondaryAuthKeyHash(),
        )
    }
}
