@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SSL configuration. If configured data-plane calls to user services will be exposed over SSL only.
 * @property cert The SSL cert data in PEM format.
 * @property cname The CName of the certificate.
 * @property key The SSL key data in PEM format. This is not returned in response of GET/PUT on the resource. To see this please call listKeys API.
 * @property status SSL status. Allowed values are Enabled and Disabled.
 */
public data class SslConfigurationResponse(
    public val cert: String? = null,
    public val cname: String? = null,
    public val key: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.SslConfigurationResponse):
            SslConfigurationResponse = SslConfigurationResponse(
            cert = javaType.cert().map({ args0 -> args0 }).orElse(null),
            cname = javaType.cname().map({ args0 -> args0 }).orElse(null),
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
