@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin

import com.pulumi.azurenative.machinelearningexperimentation.MachinelearningexperimentationFunctions.getAccountPlain
import com.pulumi.azurenative.machinelearningexperimentation.MachinelearningexperimentationFunctions.getProjectPlain
import com.pulumi.azurenative.machinelearningexperimentation.MachinelearningexperimentationFunctions.getWorkspacePlain
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.GetProjectPlainArgs
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.GetProjectPlainArgsBuilder
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs.GetProjectResult
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs.GetWorkspaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs.GetProjectResult.Companion.toKotlin as getProjectResultToKotlin
import com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin

public object MachinelearningexperimentationFunctions {
    /**
     * Gets the properties of the specified machine learning team account.
     * Azure REST API version: 2017-05-01-preview.
     * @param argument null
     * @return An object that represents a machine learning team account.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the machine learning team account.
     * @param resourceGroupName The name of the resource group to which the machine learning team account belongs.
     * @return An object that represents a machine learning team account.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningexperimentation&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return An object that represents a machine learning team account.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified machine learning project.
     * Azure REST API version: 2017-05-01-preview.
     * @param argument null
     * @return An object that represents a machine learning project.
     */
    public suspend fun getProject(argument: GetProjectPlainArgs): GetProjectResult =
        getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())

    /**
     * @see [getProject].
     * @param accountName The name of the machine learning team account.
     * @param projectName The name of the machine learning project under a team account workspace.
     * @param resourceGroupName The name of the resource group to which the machine learning team account belongs.
     * @param workspaceName The name of the machine learning team account workspace.
     * @return An object that represents a machine learning project.
     */
    public suspend fun getProject(
        accountName: String,
        projectName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetProjectResult {
        val argument = GetProjectPlainArgs(
            accountName = accountName,
            projectName = projectName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getProject].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningexperimentation&#46;kotlin&#46;inputs&#46;GetProjectPlainArgs].
     * @return An object that represents a machine learning project.
     */
    public suspend fun getProject(argument: suspend GetProjectPlainArgsBuilder.() -> Unit):
        GetProjectResult {
        val builder = GetProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectResultToKotlin(getProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified machine learning workspace.
     * Azure REST API version: 2017-05-01-preview.
     * @param argument null
     * @return An object that represents a machine learning team account workspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param accountName The name of the machine learning team account.
     * @param resourceGroupName The name of the resource group to which the machine learning team account belongs.
     * @param workspaceName The name of the machine learning team account workspace.
     * @return An object that represents a machine learning team account workspace.
     */
    public suspend fun getWorkspace(
        accountName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningexperimentation&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return An object that represents a machine learning team account workspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
