@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin

import com.pulumi.azurenative.machinelearningexperimentation.ProjectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a machine learning project.
 * Azure REST API version: 2017-05-01-preview. Prior API version in Azure Native 1.x: 2017-05-01-preview.
 * ## Example Usage
 * ### CreateProject
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var project = new AzureNative.MachineLearningExperimentation.Project("project", new()
 *     {
 *         AccountName = "testaccount",
 *         FriendlyName = "testName",
 *         Gitrepo = "https://github/abc",
 *         Location = "East US",
 *         ProjectName = "testProject",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningexperimentation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningexperimentation.NewProject(ctx, "project", &machinelearningexperimentation.ProjectArgs{
 * 			AccountName:       pulumi.String("testaccount"),
 * 			FriendlyName:      pulumi.String("testName"),
 * 			Gitrepo:           pulumi.String("https://github/abc"),
 * 			Location:          pulumi.String("East US"),
 * 			ProjectName:       pulumi.String("testProject"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 			WorkspaceName: pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningexperimentation.Project;
 * import com.pulumi.azurenative.machinelearningexperimentation.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var project = new Project("project", ProjectArgs.builder()
 *             .accountName("testaccount")
 *             .friendlyName("testName")
 *             .gitrepo("https://github/abc")
 *             .location("East US")
 *             .projectName("testProject")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningexperimentation:Project testProject /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}/projects/{projectName}
 * ```
 * @property accountName The name of the machine learning team account.
 * @property description The description of this project.
 * @property friendlyName The friendly name for this project.
 * @property gitrepo The reference to git repo for this project.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property projectName The name of the machine learning project under a team account workspace.
 * @property resourceGroupName The name of the resource group to which the machine learning team account belongs.
 * @property tags The tags of the resource.
 * @property workspaceName The name of the machine learning team account workspace.
 */
public data class ProjectArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val gitrepo: Output<String>? = null,
    public val location: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningexperimentation.ProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningexperimentation.ProjectArgs =
        com.pulumi.azurenative.machinelearningexperimentation.ProjectArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .gitrepo(gitrepo?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var gitrepo: Output<String>? = null

    private var location: Output<String>? = null

    private var projectName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("iwbrdnfybjkpnlpw")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The description of this project.
     */
    @JvmName("pqxjjcjkdkrbwgat")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The friendly name for this project.
     */
    @JvmName("yeoytlamxdxkopww")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value The reference to git repo for this project.
     */
    @JvmName("bgfxmwtfsxmcumql")
    public suspend fun gitrepo(`value`: Output<String>) {
        this.gitrepo = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("kyviirpcocgtrbjg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the machine learning project under a team account workspace.
     */
    @JvmName("mfafhjrkjbyajcdu")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("ghuraqnuxcmguvyd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("emiyfjdpyxndirla")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the machine learning team account workspace.
     */
    @JvmName("gvctjvamcotsywfe")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("iukaygucvrruaftd")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The description of this project.
     */
    @JvmName("fwqbplqetyvqliiu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The friendly name for this project.
     */
    @JvmName("rbyhqgqhcacvlmbi")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value The reference to git repo for this project.
     */
    @JvmName("ylweyqutjslhlofh")
    public suspend fun gitrepo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitrepo = mapped
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("llpvmmgwfnjoqvan")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the machine learning project under a team account workspace.
     */
    @JvmName("ffhujocnyrimyyrb")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("jyyubwkyurxowmwe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("cxjfkmslraugloxl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("plceiedmarsrfsrk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the machine learning team account workspace.
     */
    @JvmName("mybktglmbgsmuoep")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        accountName = accountName,
        description = description,
        friendlyName = friendlyName,
        gitrepo = gitrepo,
        location = location,
        projectName = projectName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
