@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs

import com.pulumi.azurenative.machinelearningexperimentation.inputs.GetAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the machine learning team account.
 * @property resourceGroupName The name of the resource group to which the machine learning team account belongs.
 */
public data class GetAccountPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningexperimentation.inputs.GetAccountPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningexperimentation.inputs.GetAccountPlainArgs =
        com.pulumi.azurenative.machinelearningexperimentation.inputs.GetAccountPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountPlainArgs].
 */
@PulumiTagMarker
public class GetAccountPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("afyuwlaebjmciftx")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("ojiurkchgjrkliko")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccountPlainArgs = GetAccountPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
