@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An object that represents a machine learning team account.
 * @property accountId The immutable id associated with this team account.
 * @property creationDate The creation date of the machine learning team account in ISO8601 format.
 * @property description The description of this workspace.
 * @property discoveryUri The uri for this machine learning team account.
 * @property friendlyName The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
 * @property id The resource ID.
 * @property keyVaultId The fully qualified arm id of the user key vault.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property name The name of the resource.
 * @property provisioningState The current deployment state of team account resource. The provisioningState is to indicate states for resource provisioning.
 * @property seats The no of users/seats who can access this team account. This property defines the charge on the team account.
 * @property storageAccount The properties of the storage account for the machine learning team account.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property vsoAccountId The fully qualified arm id of the vso account to be used for this team account.
 */
public data class GetAccountResult(
    public val accountId: String,
    public val creationDate: String,
    public val description: String? = null,
    public val discoveryUri: String,
    public val friendlyName: String? = null,
    public val id: String,
    public val keyVaultId: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val seats: String? = null,
    public val storageAccount: StorageAccountPropertiesResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vsoAccountId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningexperimentation.outputs.GetAccountResult):
            GetAccountResult = GetAccountResult(
            accountId = javaType.accountId(),
            creationDate = javaType.creationDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            discoveryUri = javaType.discoveryUri(),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            keyVaultId = javaType.keyVaultId(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            seats = javaType.seats().map({ args0 -> args0 }).orElse(null),
            storageAccount = javaType.storageAccount().let({ args0 ->
                com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs.StorageAccountPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vsoAccountId = javaType.vsoAccountId(),
        )
    }
}
