@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An object that represents a machine learning project.
 * @property accountId The immutable id of the team account which contains this project.
 * @property creationDate The creation date of the project in ISO8601 format.
 * @property description The description of this project.
 * @property friendlyName The friendly name for this project.
 * @property gitrepo The reference to git repo for this project.
 * @property id The resource ID.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property name The name of the resource.
 * @property projectId The immutable id of this project.
 * @property provisioningState The current deployment state of project resource. The provisioningState is to indicate states for resource provisioning.
 * @property tags The tags of the resource.
 * @property type The type of the resource.
 * @property workspaceId The immutable id of the workspace which contains this project.
 */
public data class GetProjectResult(
    public val accountId: String,
    public val creationDate: String,
    public val description: String? = null,
    public val friendlyName: String,
    public val gitrepo: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val projectId: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val workspaceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningexperimentation.outputs.GetProjectResult):
            GetProjectResult = GetProjectResult(
            accountId = javaType.accountId(),
            creationDate = javaType.creationDate(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName(),
            gitrepo = javaType.gitrepo().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            projectId = javaType.projectId(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            workspaceId = javaType.workspaceId(),
        )
    }
}
