@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComponentContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ComponentContainerResponse.Companion.toKotlin as componentContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ComponentContainer].
 */
@PulumiTagMarker
public class ComponentContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ComponentContainerArgs = ComponentContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ComponentContainerArgsBuilder.() -> Unit) {
        val builder = ComponentContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ComponentContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.ComponentContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ComponentContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-02-01-preview.
 * Other available API versions: 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Component Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var componentContainer = new AzureNative.MachineLearningServices.ComponentContainer("componentContainer", new()
 *     {
 *         ComponentContainerProperties = new AzureNative.MachineLearningServices.Inputs.ComponentContainerArgs
 *         {
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewComponentContainer(ctx, "componentContainer", &machinelearningservices.ComponentContainerArgs{
 * 			ComponentContainerProperties: &machinelearningservices.ComponentContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ComponentContainer;
 * import com.pulumi.azurenative.machinelearningservices.ComponentContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var componentContainer = new ComponentContainer("componentContainer", ComponentContainerArgs.builder()
 *             .componentContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ComponentContainer string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/components/{name}
 * ```
 */
public class ComponentContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.ComponentContainer,
) : KotlinCustomResource(javaResource, ComponentContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val componentContainerProperties: Output<ComponentContainerResponse>
        get() = javaResource.componentContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                componentContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ComponentContainerMapper : ResourceMapper<ComponentContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.ComponentContainer::class == javaResource::class

    override fun map(javaResource: Resource): ComponentContainer = ComponentContainer(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.ComponentContainer,
    )
}

/**
 * @see [ComponentContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ComponentContainer].
 */
public suspend fun componentContainer(
    name: String,
    block: suspend ComponentContainerResourceBuilder.() -> Unit,
): ComponentContainer {
    val builder = ComponentContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ComponentContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun componentContainer(name: String): ComponentContainer {
    val builder = ComponentContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
