@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Compute].
 */
@PulumiTagMarker
public class ComputeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ComputeArgs = ComputeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ComputeArgsBuilder.() -> Unit) {
        val builder = ComputeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Compute {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.Compute(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Compute(builtJavaResource)
    }
}

/**
 * Machine Learning compute object wrapped into ARM resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### Attach a Kubernetes Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.KubernetesArgs
 *         {
 *             ComputeType = "Kubernetes",
 *             Description = "some compute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.KubernetesPropertiesArgs
 *             {
 *                 DefaultInstanceType = "defaultInstanceType",
 *                 InstanceTypes =
 *                 {
 *                     { "defaultInstanceType", new AzureNative.MachineLearningServices.Inputs.InstanceTypeSchemaArgs
 *                     {
 *                         Resources = new AzureNative.MachineLearningServices.Inputs.InstanceTypeSchemaResourcesArgs
 *                         {
 *                             Limits =
 *                             {
 *                                 { "cpu", "1" },
 *                                 { "memory", "4Gi" },
 *                                 { "nvidia.com/gpu", null },
 *                             },
 *                             Requests =
 *                             {
 *                                 { "cpu", "1" },
 *                                 { "memory", "4Gi" },
 *                                 { "nvidia.com/gpu", null },
 *                             },
 *                         },
 *                     } },
 *                 },
 *                 Namespace = "default",
 *             },
 *             ResourceId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * ComputeName: pulumi.String("compute123"),
 * Location: pulumi.String("eastus"),
 * Properties: machinelearningservices.Kubernetes{
 * ComputeType: "Kubernetes",
 * Description: "some compute",
 * Properties: machinelearningservices.KubernetesProperties{
 * DefaultInstanceType: "defaultInstanceType",
 * InstanceTypes: interface{}{
 * DefaultInstanceType: machinelearningservices.InstanceTypeSchema{
 * Resources: machinelearningservices.InstanceTypeSchemaResources{
 * Limits: interface{}{
 * Cpu: "1",
 * Memory: "4Gi",
 * Nvidia.com/gpu: nil,
 * },
 * Requests: interface{}{
 * Cpu: "1",
 * Memory: "4Gi",
 * Nvidia.com/gpu: nil,
 * },
 * },
 * },
 * },
 * Namespace: "default",
 * },
 * ResourceId: "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 * },
 * ResourceGroupName: pulumi.String("testrg123"),
 * WorkspaceName: pulumi.String("workspaces123"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "Kubernetes"),
 *                 Map.entry("description", "some compute"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("defaultInstanceType", "defaultInstanceType"),
 *                     Map.entry("instanceTypes", Map.of("defaultInstanceType", Map.of("resources", Map.ofEntries(
 *                         Map.entry("limits", Map.ofEntries(
 *                             Map.entry("cpu", "1"),
 *                             Map.entry("memory", "4Gi"),
 *                             Map.entry("nvidia.com/gpu", null)
 *                         )),
 *                         Map.entry("requests", Map.ofEntries(
 *                             Map.entry("cpu", "1"),
 *                             Map.entry("memory", "4Gi"),
 *                             Map.entry("nvidia.com/gpu", null)
 *                         ))
 *                     )))),
 *                     Map.entry("namespace", "default")
 *                 )),
 *                 Map.entry("resourceId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2")
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a AML Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputeArgs
 *         {
 *             ComputeType = "AmlCompute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputePropertiesArgs
 *             {
 *                 EnableNodePublicIp = true,
 *                 IsolatedNetwork = false,
 *                 OsType = "Windows",
 *                 RemoteLoginPortPublicAccess = "NotSpecified",
 *                 ScaleSettings = new AzureNative.MachineLearningServices.Inputs.ScaleSettingsArgs
 *                 {
 *                     MaxNodeCount = 1,
 *                     MinNodeCount = 0,
 *                     NodeIdleTimeBeforeScaleDown = "PT5M",
 *                 },
 *                 VirtualMachineImage = new AzureNative.MachineLearningServices.Inputs.VirtualMachineImageArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myImageGallery/images/myImageDefinition/versions/0.0.1",
 *                 },
 *                 VmPriority = "Dedicated",
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AmlCompute{
 * 				ComputeType: "AmlCompute",
 * 				Properties: machinelearningservices.AmlComputeProperties{
 * 					EnableNodePublicIp:          true,
 * 					IsolatedNetwork:             false,
 * 					OsType:                      "Windows",
 * 					RemoteLoginPortPublicAccess: "NotSpecified",
 * 					ScaleSettings: machinelearningservices.ScaleSettings{
 * 						MaxNodeCount:                1,
 * 						MinNodeCount:                0,
 * 						NodeIdleTimeBeforeScaleDown: "PT5M",
 * 					},
 * 					VirtualMachineImage: machinelearningservices.VirtualMachineImage{
 * 						Id: "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myImageGallery/images/myImageDefinition/versions/0.0.1",
 * 					},
 * 					VmPriority: "Dedicated",
 * 					VmSize:     "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "AmlCompute"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("enableNodePublicIp", true),
 *                     Map.entry("isolatedNetwork", false),
 *                     Map.entry("osType", "Windows"),
 *                     Map.entry("remoteLoginPortPublicAccess", "NotSpecified"),
 *                     Map.entry("scaleSettings", Map.ofEntries(
 *                         Map.entry("maxNodeCount", 1),
 *                         Map.entry("minNodeCount", 0),
 *                         Map.entry("nodeIdleTimeBeforeScaleDown", "PT5M")
 *                     )),
 *                     Map.entry("virtualMachineImage", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myImageGallery/images/myImageDefinition/versions/0.0.1")),
 *                     Map.entry("vmPriority", "Dedicated"),
 *                     Map.entry("vmSize", "STANDARD_NC6")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a DataFactory Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.DataFactoryArgs
 *         {
 *             ComputeType = "DataFactory",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.DataFactory{
 * 				ComputeType: "DataFactory",
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.of("computeType", "DataFactory"))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an AKS Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AKSArgs
 *         {
 *             ComputeType = "AKS",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AKS{
 * 				ComputeType: "AKS",
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.of("computeType", "AKS"))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ComputeInstance Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceArgs
 *         {
 *             ComputeType = "ComputeInstance",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstancePropertiesArgs
 *             {
 *                 ApplicationSharingPolicy = "Personal",
 *                 ComputeInstanceAuthorizationType = "personal",
 *                 CustomServices = new[]
 *                 {
 *                     new AzureNative.MachineLearningServices.Inputs.CustomServiceArgs
 *                     {
 *                         Docker = new AzureNative.MachineLearningServices.Inputs.DockerArgs
 *                         {
 *                             Privileged = true,
 *                         },
 *                         Endpoints = new[]
 *                         {
 *                             new AzureNative.MachineLearningServices.Inputs.EndpointArgs
 *                             {
 *                                 Name = "connect",
 *                                 Protocol = "http",
 *                                 Published = 8787,
 *                                 Target = 8787,
 *                             },
 *                         },
 *                         EnvironmentVariables =
 *                         {
 *                             { "test_variable", new AzureNative.MachineLearningServices.Inputs.EnvironmentVariableArgs
 *                             {
 *                                 Type = "local",
 *                                 Value = "test_value",
 *                             } },
 *                         },
 *                         Image = new AzureNative.MachineLearningServices.Inputs.ImageArgs
 *                         {
 *                             Reference = "ghcr.io/azure/rocker-rstudio-ml-verse:latest",
 *                             Type = "docker",
 *                         },
 *                         Name = "rstudio",
 *                         Volumes = new[]
 *                         {
 *                             new AzureNative.MachineLearningServices.Inputs.VolumeDefinitionArgs
 *                             {
 *                                 ReadOnly = false,
 *                                 Source = "/home/azureuser/cloudfiles",
 *                                 Target = "/home/azureuser/cloudfiles",
 *                                 Type = "bind",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 PersonalComputeInstanceSettings = new AzureNative.MachineLearningServices.Inputs.PersonalComputeInstanceSettingsArgs
 *                 {
 *                     AssignedUser = new AzureNative.MachineLearningServices.Inputs.AssignedUserArgs
 *                     {
 *                         ObjectId = "00000000-0000-0000-0000-000000000000",
 *                         TenantId = "00000000-0000-0000-0000-000000000000",
 *                     },
 *                 },
 *                 SshSettings = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceSshSettingsArgs
 *                 {
 *                     SshPublicAccess = "Disabled",
 *                 },
 *                 Subnet = new AzureNative.MachineLearningServices.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "test-subnet-resource-id",
 *                 },
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.ComputeInstance{
 * 				ComputeType: "ComputeInstance",
 * 				Properties: machinelearningservices.ComputeInstanceProperties{
 * 					ApplicationSharingPolicy:         "Personal",
 * 					ComputeInstanceAuthorizationType: "personal",
 * 					CustomServices: []machinelearningservices.CustomService{
 * 						{
 * 							Docker: {
 * 								Privileged: true,
 * 							},
 * 							Endpoints: []machinelearningservices.Endpoint{
 * 								{
 * 									Name:      "connect",
 * 									Protocol:  "http",
 * 									Published: 8787,
 * 									Target:    8787,
 * 								},
 * 							},
 * 							EnvironmentVariables: {
 * 								Test_variable: {
 * 									Type:  "local",
 * 									Value: "test_value",
 * 								},
 * 							},
 * 							Image: {
 * 								Reference: "ghcr.io/azure/rocker-rstudio-ml-verse:latest",
 * 								Type:      "docker",
 * 							},
 * 							Name: "rstudio",
 * 							Volumes: []machinelearningservices.VolumeDefinition{
 * 								{
 * 									ReadOnly: false,
 * 									Source:   "/home/azureuser/cloudfiles",
 * 									Target:   "/home/azureuser/cloudfiles",
 * 									Type:     "bind",
 * 								},
 * 							},
 * 						},
 * 					},
 * 					PersonalComputeInstanceSettings: machinelearningservices.PersonalComputeInstanceSettings{
 * 						AssignedUser: machinelearningservices.AssignedUser{
 * 							ObjectId: "00000000-0000-0000-0000-000000000000",
 * 							TenantId: "00000000-0000-0000-0000-000000000000",
 * 						},
 * 					},
 * 					SshSettings: machinelearningservices.ComputeInstanceSshSettings{
 * 						SshPublicAccess: "Disabled",
 * 					},
 * 					Subnet: machinelearningservices.ResourceId{
 * 						Id: "test-subnet-resource-id",
 * 					},
 * 					VmSize: "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "ComputeInstance"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("applicationSharingPolicy", "Personal"),
 *                     Map.entry("computeInstanceAuthorizationType", "personal"),
 *                     Map.entry("customServices", Map.ofEntries(
 *                         Map.entry("docker", Map.of("privileged", true)),
 *                         Map.entry("endpoints", Map.ofEntries(
 *                             Map.entry("name", "connect"),
 *                             Map.entry("protocol", "http"),
 *                             Map.entry("published", 8787),
 *                             Map.entry("target", 8787)
 *                         )),
 *                         Map.entry("environmentVariables", Map.of("test_variable", Map.ofEntries(
 *                             Map.entry("type", "local"),
 *                             Map.entry("value", "test_value")
 *                         ))),
 *                         Map.entry("image", Map.ofEntries(
 *                             Map.entry("reference", "ghcr.io/azure/rocker-rstudio-ml-verse:latest"),
 *                             Map.entry("type", "docker")
 *                         )),
 *                         Map.entry("name", "rstudio"),
 *                         Map.entry("volumes", Map.ofEntries(
 *                             Map.entry("readOnly", false),
 *                             Map.entry("source", "/home/azureuser/cloudfiles"),
 *                             Map.entry("target", "/home/azureuser/cloudfiles"),
 *                             Map.entry("type", "bind")
 *                         ))
 *                     )),
 *                     Map.entry("personalComputeInstanceSettings", Map.of("assignedUser", Map.ofEntries(
 *                         Map.entry("objectId", "00000000-0000-0000-0000-000000000000"),
 *                         Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *                     ))),
 *                     Map.entry("sshSettings", Map.of("sshPublicAccess", "Disabled")),
 *                     Map.entry("subnet", Map.of("id", "test-subnet-resource-id")),
 *                     Map.entry("vmSize", "STANDARD_NC6")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ComputeInstance Compute with Schedules
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceArgs
 *         {
 *             ComputeType = "ComputeInstance",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstancePropertiesArgs
 *             {
 *                 ApplicationSharingPolicy = "Personal",
 *                 ComputeInstanceAuthorizationType = "personal",
 *                 PersonalComputeInstanceSettings = new AzureNative.MachineLearningServices.Inputs.PersonalComputeInstanceSettingsArgs
 *                 {
 *                     AssignedUser = new AzureNative.MachineLearningServices.Inputs.AssignedUserArgs
 *                     {
 *                         ObjectId = "00000000-0000-0000-0000-000000000000",
 *                         TenantId = "00000000-0000-0000-0000-000000000000",
 *                     },
 *                 },
 *                 Schedules = new AzureNative.MachineLearningServices.Inputs.ComputeSchedulesArgs
 *                 {
 *                     ComputeStartStop = new[]
 *                     {
 *                         new AzureNative.MachineLearningServices.Inputs.ComputeStartStopScheduleArgs
 *                         {
 *                             Action = "Stop",
 *                             Cron = new AzureNative.MachineLearningServices.Inputs.CronArgs
 *                             {
 *                                 Expression = "0 18 * * *",
 *                                 StartTime = "2021-04-23T01:30:00",
 *                                 TimeZone = "Pacific Standard Time",
 *                             },
 *                             Status = "Enabled",
 *                             TriggerType = "Cron",
 *                         },
 *                     },
 *                 },
 *                 SshSettings = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceSshSettingsArgs
 *                 {
 *                     SshPublicAccess = "Disabled",
 *                 },
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.ComputeInstance{
 * 				ComputeType: "ComputeInstance",
 * 				Properties: machinelearningservices.ComputeInstanceProperties{
 * 					ApplicationSharingPolicy:         "Personal",
 * 					ComputeInstanceAuthorizationType: "personal",
 * 					PersonalComputeInstanceSettings: machinelearningservices.PersonalComputeInstanceSettings{
 * 						AssignedUser: machinelearningservices.AssignedUser{
 * 							ObjectId: "00000000-0000-0000-0000-000000000000",
 * 							TenantId: "00000000-0000-0000-0000-000000000000",
 * 						},
 * 					},
 * 					Schedules: machinelearningservices.ComputeSchedules{
 * 						ComputeStartStop: []machinelearningservices.ComputeStartStopSchedule{
 * 							{
 * 								Action: "Stop",
 * 								Cron: {
 * 									Expression: "0 18 * * *",
 * 									StartTime:  "2021-04-23T01:30:00",
 * 									TimeZone:   "Pacific Standard Time",
 * 								},
 * 								Status:      "Enabled",
 * 								TriggerType: "Cron",
 * 							},
 * 						},
 * 					},
 * 					SshSettings: machinelearningservices.ComputeInstanceSshSettings{
 * 						SshPublicAccess: "Disabled",
 * 					},
 * 					VmSize: "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "ComputeInstance"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("applicationSharingPolicy", "Personal"),
 *                     Map.entry("computeInstanceAuthorizationType", "personal"),
 *                     Map.entry("personalComputeInstanceSettings", Map.of("assignedUser", Map.ofEntries(
 *                         Map.entry("objectId", "00000000-0000-0000-0000-000000000000"),
 *                         Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *                     ))),
 *                     Map.entry("schedules", Map.of("computeStartStop", Map.ofEntries(
 *                         Map.entry("action", "Stop"),
 *                         Map.entry("cron", Map.ofEntries(
 *                             Map.entry("expression", "0 18 * * *"),
 *                             Map.entry("startTime", "2021-04-23T01:30:00"),
 *                             Map.entry("timeZone", "Pacific Standard Time")
 *                         )),
 *                         Map.entry("status", "Enabled"),
 *                         Map.entry("triggerType", "Cron")
 *                     ))),
 *                     Map.entry("sshSettings", Map.of("sshPublicAccess", "Disabled")),
 *                     Map.entry("vmSize", "STANDARD_NC6")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ComputeInstance Compute with minimal inputs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceArgs
 *         {
 *             ComputeType = "ComputeInstance",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstancePropertiesArgs
 *             {
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.ComputeInstance{
 * 				ComputeType: "ComputeInstance",
 * 				Properties: machinelearningservices.ComputeInstanceProperties{
 * 					VmSize: "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "ComputeInstance"),
 *                 Map.entry("properties", Map.of("vmSize", "STANDARD_NC6"))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a AML Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputeArgs
 *         {
 *             ComputeType = "AmlCompute",
 *             Description = "some compute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputePropertiesArgs
 *             {
 *                 ScaleSettings = new AzureNative.MachineLearningServices.Inputs.ScaleSettingsArgs
 *                 {
 *                     MaxNodeCount = 4,
 *                     MinNodeCount = 4,
 *                     NodeIdleTimeBeforeScaleDown = "PT5M",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AmlCompute{
 * 				ComputeType: "AmlCompute",
 * 				Description: "some compute",
 * 				Properties: machinelearningservices.AmlComputeProperties{
 * 					ScaleSettings: machinelearningservices.ScaleSettings{
 * 						MaxNodeCount:                4,
 * 						MinNodeCount:                4,
 * 						NodeIdleTimeBeforeScaleDown: "PT5M",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "AmlCompute"),
 *                 Map.entry("description", "some compute"),
 *                 Map.entry("properties", Map.of("scaleSettings", Map.ofEntries(
 *                     Map.entry("maxNodeCount", 4),
 *                     Map.entry("minNodeCount", 4),
 *                     Map.entry("nodeIdleTimeBeforeScaleDown", "PT5M")
 *                 )))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Update an AKS Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AKSArgs
 *         {
 *             ComputeType = "AKS",
 *             Description = "some compute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.AKSSchemaPropertiesArgs
 *             {
 *                 AgentCount = 4,
 *             },
 *             ResourceId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AKS{
 * 				ComputeType: "AKS",
 * 				Description: "some compute",
 * 				Properties: machinelearningservices.AKSSchemaProperties{
 * 					AgentCount: 4,
 * 				},
 * 				ResourceId: "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "AKS"),
 *                 Map.entry("description", "some compute"),
 *                 Map.entry("properties", Map.of("agentCount", 4)),
 *                 Map.entry("resourceId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2")
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Compute compute123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/computes/{computeName}
 * ```
 */
public class Compute internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.Compute,
) : KotlinCustomResource(javaResource, ComputeMapper) {
    /**
     * The identity of the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Compute properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The sku of the workspace.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ComputeMapper : ResourceMapper<Compute> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.Compute::class == javaResource::class

    override fun map(javaResource: Resource): Compute = Compute(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.Compute,
    )
}

/**
 * @see [Compute].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Compute].
 */
public suspend fun compute(name: String, block: suspend ComputeResourceBuilder.() -> Unit):
    Compute {
    val builder = ComputeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Compute].
 * @param name The _unique_ name of the resulting resource.
 */
public fun compute(name: String): Compute {
    val builder = ComputeResourceBuilder()
    builder.name(name)
    return builder.build()
}
