@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.EndpointDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2024-01-01-preview.
 * ## Example Usage
 * ### Create Endpoint Deployment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpointDeployment = new AzureNative.MachineLearningServices.EndpointDeployment("endpointDeployment", new()
 *     {
 *         DeploymentName = "text-davinci-003",
 *         EndpointName = "Azure.OpenAI",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.OpenAIEndpointDeploymentResourcePropertiesArgs
 *         {
 *             Model = new AzureNative.MachineLearningServices.Inputs.EndpointDeploymentModelArgs
 *             {
 *                 Format = "OpenAI",
 *                 Name = "text-davinci-003",
 *                 Version = "1",
 *             },
 *             Type = "Azure.OpenAI",
 *             VersionUpgradeOption = "OnceNewDefaultVersionAvailable",
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewEndpointDeployment(ctx, "endpointDeployment", &machinelearningservices.EndpointDeploymentArgs{
 * 			DeploymentName: pulumi.String("text-davinci-003"),
 * 			EndpointName:   pulumi.String("Azure.OpenAI"),
 * 			Properties: machinelearningservices.OpenAIEndpointDeploymentResourceProperties{
 * 				Model: machinelearningservices.EndpointDeploymentModel{
 * 					Format:  "OpenAI",
 * 					Name:    "text-davinci-003",
 * 					Version: "1",
 * 				},
 * 				Type:                 "Azure.OpenAI",
 * 				VersionUpgradeOption: "OnceNewDefaultVersionAvailable",
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.EndpointDeployment;
 * import com.pulumi.azurenative.machinelearningservices.EndpointDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpointDeployment = new EndpointDeployment("endpointDeployment", EndpointDeploymentArgs.builder()
 *             .deploymentName("text-davinci-003")
 *             .endpointName("Azure.OpenAI")
 *             .properties(Map.ofEntries(
 *                 Map.entry("model", Map.ofEntries(
 *                     Map.entry("format", "OpenAI"),
 *                     Map.entry("name", "text-davinci-003"),
 *                     Map.entry("version", "1")
 *                 )),
 *                 Map.entry("type", "Azure.OpenAI"),
 *                 Map.entry("versionUpgradeOption", "OnceNewDefaultVersionAvailable")
 *             ))
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:EndpointDeployment text-davinci-003 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/endpoints/{endpointName}/deployments/{deploymentName}
 * ```
 * @property deploymentName Name of the deployment resource
 * @property endpointName Name of the endpoint resource.
 * @property properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Azure Machine Learning Workspace Name
 */
public data class EndpointDeploymentArgs(
    public val deploymentName: Output<String>? = null,
    public val endpointName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.EndpointDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.EndpointDeploymentArgs =
        com.pulumi.azurenative.machinelearningservices.EndpointDeploymentArgs.builder()
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointDeploymentArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentArgsBuilder internal constructor() {
    private var deploymentName: Output<String>? = null

    private var endpointName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Name of the deployment resource
     */
    @JvmName("cyynudcdrqmjlgpx")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value Name of the endpoint resource.
     */
    @JvmName("tkyxynrwdyuppewe")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value
     */
    @JvmName("hhvgcplqwlksennd")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ftuaalrbtlsdaqiu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("safnmmcrvmydlsgn")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Name of the deployment resource
     */
    @JvmName("avyfsabvtrapwvkn")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value Name of the endpoint resource.
     */
    @JvmName("ljuhlgkhtofvxkkw")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value
     */
    @JvmName("aqtuhgaylfuqnuug")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("imbbjcpvijppwuvq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Machine Learning Workspace Name
     */
    @JvmName("fxmahbmiynuucaqn")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EndpointDeploymentArgs = EndpointDeploymentArgs(
        deploymentName = deploymentName,
        endpointName = endpointName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
