@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentContainerResponse.Companion.toKotlin as environmentContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EnvironmentContainer].
 */
@PulumiTagMarker
public class EnvironmentContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentContainerArgs = EnvironmentContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentContainerArgsBuilder.() -> Unit) {
        val builder = EnvironmentContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EnvironmentContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.EnvironmentContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnvironmentContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Environment Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environmentContainer = new AzureNative.MachineLearningServices.EnvironmentContainer("environmentContainer", new()
 *     {
 *         EnvironmentContainerProperties = new AzureNative.MachineLearningServices.Inputs.EnvironmentContainerArgs
 *         {
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *         },
 *         Name = "testEnvironment",
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewEnvironmentContainer(ctx, "environmentContainer", &machinelearningservices.EnvironmentContainerArgs{
 * 			EnvironmentContainerProperties: &machinelearningservices.EnvironmentContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("testEnvironment"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentContainer;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environmentContainer = new EnvironmentContainer("environmentContainer", EnvironmentContainerArgs.builder()
 *             .environmentContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 )),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *             ))
 *             .name("testEnvironment")
 *             .resourceGroupName("testrg123")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:EnvironmentContainer testEnvironment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/environments/{name}
 * ```
 */
public class EnvironmentContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.EnvironmentContainer,
) : KotlinCustomResource(javaResource, EnvironmentContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val environmentContainerProperties: Output<EnvironmentContainerResponse>
        get() = javaResource.environmentContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnvironmentContainerMapper : ResourceMapper<EnvironmentContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.EnvironmentContainer::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentContainer = EnvironmentContainer(
        javaResource
            as com.pulumi.azurenative.machinelearningservices.EnvironmentContainer,
    )
}

/**
 * @see [EnvironmentContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentContainer].
 */
public suspend fun environmentContainer(
    name: String,
    block: suspend EnvironmentContainerResourceBuilder.() -> Unit,
): EnvironmentContainer {
    val builder = EnvironmentContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentContainer(name: String): EnvironmentContainer {
    val builder = EnvironmentContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
