@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturestoreEntityContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.FeaturestoreEntityContainerResponse.Companion.toKotlin as featurestoreEntityContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [FeaturestoreEntityContainerEntity].
 */
@PulumiTagMarker
public class FeaturestoreEntityContainerEntityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FeaturestoreEntityContainerEntityArgs = FeaturestoreEntityContainerEntityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FeaturestoreEntityContainerEntityArgsBuilder.() -> Unit) {
        val builder = FeaturestoreEntityContainerEntityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FeaturestoreEntityContainerEntity {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntity(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FeaturestoreEntityContainerEntity(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Featurestore Entity Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var featurestoreEntityContainerEntity = new AzureNative.MachineLearningServices.FeaturestoreEntityContainerEntity("featurestoreEntityContainerEntity", new()
 *     {
 *         FeaturestoreEntityContainerProperties = new AzureNative.MachineLearningServices.Inputs.FeaturestoreEntityContainerArgs
 *         {
 *             Description = "string",
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewFeaturestoreEntityContainerEntity(ctx, "featurestoreEntityContainerEntity", &machinelearningservices.FeaturestoreEntityContainerEntityArgs{
 * 			FeaturestoreEntityContainerProperties: &machinelearningservices.FeaturestoreEntityContainerArgs{
 * 				Description: pulumi.String("string"),
 * 				IsArchived:  pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntity;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var featurestoreEntityContainerEntity = new FeaturestoreEntityContainerEntity("featurestoreEntityContainerEntity", FeaturestoreEntityContainerEntityArgs.builder()
 *             .featurestoreEntityContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("isArchived", false),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:FeaturestoreEntityContainerEntity string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/featurestoreEntities/{name}
 * ```
 */
public class FeaturestoreEntityContainerEntity internal constructor(
    override val javaResource:
    com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntity,
) : KotlinCustomResource(javaResource, FeaturestoreEntityContainerEntityMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val featurestoreEntityContainerProperties: Output<FeaturestoreEntityContainerResponse>
        get() = javaResource.featurestoreEntityContainerProperties().applyValue({ args0 ->
            args0.let({ args0 -> featurestoreEntityContainerResponseToKotlin(args0) })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FeaturestoreEntityContainerEntityMapper :
    ResourceMapper<FeaturestoreEntityContainerEntity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntity::class == javaResource::class

    override fun map(javaResource: Resource): FeaturestoreEntityContainerEntity =
        FeaturestoreEntityContainerEntity(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntity,
        )
}

/**
 * @see [FeaturestoreEntityContainerEntity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FeaturestoreEntityContainerEntity].
 */
public suspend fun featurestoreEntityContainerEntity(
    name: String,
    block: suspend FeaturestoreEntityContainerEntityResourceBuilder.() -> Unit,
):
    FeaturestoreEntityContainerEntity {
    val builder = FeaturestoreEntityContainerEntityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FeaturestoreEntityContainerEntity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun featurestoreEntityContainerEntity(name: String): FeaturestoreEntityContainerEntity {
    val builder = FeaturestoreEntityContainerEntityResourceBuilder()
    builder.name(name)
    return builder.build()
}
