@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.InferenceEndpointArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-08-01-preview.
 * Other available API versions: 2024-01-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:InferenceEndpoint string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/inferencePools/{poolName}/endpoints/{endpointName}
 * ```
 * @property endpointName InferenceEndpoint name.
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property inferenceEndpointProperties [Required] Additional attributes of the entity.
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
 * @property location The geo-location where the resource lives
 * @property poolName InferencePool name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Sku details required for ARM contract for Autoscaling.
 * @property tags Resource tags.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class InferenceEndpointArgs(
    public val endpointName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val inferenceEndpointProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceEndpointArgs>? =
        null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val poolName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.InferenceEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.InferenceEndpointArgs =
        com.pulumi.azurenative.machinelearningservices.InferenceEndpointArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inferenceEndpointProperties(
                inferenceEndpointProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InferenceEndpointArgs].
 */
@PulumiTagMarker
public class InferenceEndpointArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var inferenceEndpointProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceEndpointArgs>? =
        null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var poolName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value InferenceEndpoint name.
     */
    @JvmName("qsdrnmrqwoanerxb")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("lulefsravqejibrd")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("cgxcqpenulahdngc")
    public suspend
    fun inferenceEndpointProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceEndpointArgs>) {
        this.inferenceEndpointProperties = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("prciswpkfefkknnh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("alwadgyryorujvca")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value InferencePool name.
     */
    @JvmName("ojvbrrervnotadtu")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qeepusnrbteublpw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("heqwnhebcvglursq")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gvkugxcxtxsdjkxv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("iqtuqxpkaytvrlkk")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value InferenceEndpoint name.
     */
    @JvmName("icgcgdgjrskpgsrm")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("waoenylmgrelhigd")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("aegvujxtaysmvraf")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("xafxcfimaekdlngo")
    public suspend
    fun inferenceEndpointProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inferenceEndpointProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("kbdjjokhnlxpqhjq")
    public suspend
    fun inferenceEndpointProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceEndpointArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.InferenceEndpointArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inferenceEndpointProperties = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("lcqgkvncvdguqcnl")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kqdrjqrdxfowifbr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value InferencePool name.
     */
    @JvmName("wytbkrahxmbgoegk")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sfjwtrfbfkelunkj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("qlapvwvkummkblyr")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("qyihiwcwiqmxoxkt")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fvtjhqqbmafbhhvs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cxycwhqqtbcnykhn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("aiugjmakbubptnmj")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): InferenceEndpointArgs = InferenceEndpointArgs(
        endpointName = endpointName,
        identity = identity,
        inferenceEndpointProperties = inferenceEndpointProperties,
        kind = kind,
        location = location,
        poolName = poolName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceName = workspaceName,
    )
}
