@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LinkedWorkspacePropsResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LinkedWorkspacePropsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LinkedWorkspace].
 */
@PulumiTagMarker
public class LinkedWorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkedWorkspaceArgs = LinkedWorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkedWorkspaceArgsBuilder.() -> Unit) {
        val builder = LinkedWorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LinkedWorkspace {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.LinkedWorkspace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkedWorkspace(builtJavaResource)
    }
}

/**
 * Linked workspace.
 * Azure REST API version: 2020-05-15-preview. Prior API version in Azure Native 1.x: 2020-03-01.
 * ## Example Usage
 * ### CreateLinkedWorkspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedWorkspace = new AzureNative.MachineLearningServices.LinkedWorkspace("linkedWorkspace", new()
 *     {
 *         LinkName = "link-1",
 *         Name = "link-1",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.LinkedWorkspacePropsArgs
 *         {
 *             LinkedWorkspaceResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/linkedWorkspace-1",
 *             UserAssignedIdentityResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai1",
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "workspace-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewLinkedWorkspace(ctx, "linkedWorkspace", &machinelearningservices.LinkedWorkspaceArgs{
 * 			LinkName: pulumi.String("link-1"),
 * 			Name:     pulumi.String("link-1"),
 * 			Properties: &machinelearningservices.LinkedWorkspacePropsArgs{
 * 				LinkedWorkspaceResourceId:      pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/linkedWorkspace-1"),
 * 				UserAssignedIdentityResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("workspace-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.LinkedWorkspace;
 * import com.pulumi.azurenative.machinelearningservices.LinkedWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedWorkspace = new LinkedWorkspace("linkedWorkspace", LinkedWorkspaceArgs.builder()
 *             .linkName("link-1")
 *             .name("link-1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("linkedWorkspaceResourceId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/linkedWorkspace-1"),
 *                 Map.entry("userAssignedIdentityResourceId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai1")
 *             ))
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("workspace-1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:LinkedWorkspace link-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/linkedWorkspaces/{linkName}
 * ```
 */
public class LinkedWorkspace internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.LinkedWorkspace,
) : KotlinCustomResource(javaResource, LinkedWorkspaceMapper) {
    /**
     * Friendly name of the linked workspace.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * LinkedWorkspace specific properties.
     */
    public val properties: Output<LinkedWorkspacePropsResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type of linked workspace.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkedWorkspaceMapper : ResourceMapper<LinkedWorkspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.LinkedWorkspace::class == javaResource::class

    override fun map(javaResource: Resource): LinkedWorkspace = LinkedWorkspace(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.LinkedWorkspace,
    )
}

/**
 * @see [LinkedWorkspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkedWorkspace].
 */
public suspend fun linkedWorkspace(
    name: String,
    block: suspend LinkedWorkspaceResourceBuilder.() -> Unit,
): LinkedWorkspace {
    val builder = LinkedWorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkedWorkspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkedWorkspace(name: String): LinkedWorkspace {
    val builder = LinkedWorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
