@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.LinkedWorkspaceArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.LinkedWorkspacePropsArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.LinkedWorkspacePropsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Linked workspace.
 * Azure REST API version: 2020-05-15-preview. Prior API version in Azure Native 1.x: 2020-03-01.
 * ## Example Usage
 * ### CreateLinkedWorkspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedWorkspace = new AzureNative.MachineLearningServices.LinkedWorkspace("linkedWorkspace", new()
 *     {
 *         LinkName = "link-1",
 *         Name = "link-1",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.LinkedWorkspacePropsArgs
 *         {
 *             LinkedWorkspaceResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/linkedWorkspace-1",
 *             UserAssignedIdentityResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai1",
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "workspace-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewLinkedWorkspace(ctx, "linkedWorkspace", &machinelearningservices.LinkedWorkspaceArgs{
 * 			LinkName: pulumi.String("link-1"),
 * 			Name:     pulumi.String("link-1"),
 * 			Properties: &machinelearningservices.LinkedWorkspacePropsArgs{
 * 				LinkedWorkspaceResourceId:      pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/linkedWorkspace-1"),
 * 				UserAssignedIdentityResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("workspace-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.LinkedWorkspace;
 * import com.pulumi.azurenative.machinelearningservices.LinkedWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedWorkspace = new LinkedWorkspace("linkedWorkspace", LinkedWorkspaceArgs.builder()
 *             .linkName("link-1")
 *             .name("link-1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("linkedWorkspaceResourceId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/linkedWorkspace-1"),
 *                 Map.entry("userAssignedIdentityResourceId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.ManagedIdentity/userAssignedIdentities/uai1")
 *             ))
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("workspace-1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:LinkedWorkspace link-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/linkedWorkspaces/{linkName}
 * ```
 * @property linkName Friendly name of the linked workspace
 * @property name Friendly name of the linked workspace
 * @property properties LinkedWorkspace specific properties.
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class LinkedWorkspaceArgs(
    public val linkName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<LinkedWorkspacePropsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.LinkedWorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.LinkedWorkspaceArgs =
        com.pulumi.azurenative.machinelearningservices.LinkedWorkspaceArgs.builder()
            .linkName(linkName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedWorkspaceArgs].
 */
@PulumiTagMarker
public class LinkedWorkspaceArgsBuilder internal constructor() {
    private var linkName: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<LinkedWorkspacePropsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Friendly name of the linked workspace
     */
    @JvmName("dtmoqoxdcqssrcwl")
    public suspend fun linkName(`value`: Output<String>) {
        this.linkName = value
    }

    /**
     * @param value Friendly name of the linked workspace
     */
    @JvmName("xjolvxiryvbbeybg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value LinkedWorkspace specific properties.
     */
    @JvmName("pryjkqlbqmacsygq")
    public suspend fun properties(`value`: Output<LinkedWorkspacePropsArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("oonccyrvtptgvtcm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("fjtwrnlvomlgnvtr")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Friendly name of the linked workspace
     */
    @JvmName("wxjrxdaofqdiioar")
    public suspend fun linkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkName = mapped
    }

    /**
     * @param value Friendly name of the linked workspace
     */
    @JvmName("cpfjfgjfkbkooswk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value LinkedWorkspace specific properties.
     */
    @JvmName("gqrhkerhxtkdyvxe")
    public suspend fun properties(`value`: LinkedWorkspacePropsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument LinkedWorkspace specific properties.
     */
    @JvmName("tqpxlcikrojjkuta")
    public suspend fun properties(argument: suspend LinkedWorkspacePropsArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedWorkspacePropsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("vmkaxenbljwusvdl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("cfjvynefpjwpldfn")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): LinkedWorkspaceArgs = LinkedWorkspaceArgs(
        linkName = linkName,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
