@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getBatchDeploymentPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getBatchEndpointPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getCapacityReservationGroupPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getCodeContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getCodeVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getComponentContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getComponentVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getComputeAllowedResizeSizesPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getComputePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getDataContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getDataVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getDatastorePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getEndpointDeploymentPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getEnvironmentContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getEnvironmentSpecificationVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getEnvironmentVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getFeaturesetContainerEntityPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getFeaturesetVersionFeaturePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getFeaturesetVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getFeaturestoreEntityContainerEntityPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getFeaturestoreEntityVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getInferenceEndpointPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getInferenceGroupPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getInferenceGroupStatusPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getInferencePoolPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getInferencePoolStatusPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getJobPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getLabelingJobPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getLinkedServicePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getLinkedWorkspacePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getMachineLearningDatasetPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getMachineLearningDatastorePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getManagedNetworkSettingsRulePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getMarketplaceSubscriptionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getModelContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getModelVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getOnlineDeploymentLogsPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getOnlineDeploymentPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getOnlineEndpointPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getOnlineEndpointTokenPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryCodeContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryCodeVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryComponentContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryComponentVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryDataContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryDataVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryEnvironmentContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryEnvironmentVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryModelContainerPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryModelVersionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getRegistryPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getSchedulePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getServerlessEndpointPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getServerlessEndpointStatusPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getWorkspaceConnectionPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.getWorkspacePlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listBatchEndpointKeysPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listComputeKeysPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listComputeNodesPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listDatastoreSecretsPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listEndpointKeysPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listFeaturesetVersionFeaturesPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listFeaturesetVersionMaterializationJobsPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listOnlineEndpointKeysPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listServerlessEndpointKeysPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listWorkspaceConnectionSecretsPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listWorkspaceKeysPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listWorkspaceNotebookAccessTokenPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listWorkspaceNotebookKeysPlain
import com.pulumi.azurenative.machinelearningservices.MachinelearningservicesFunctions.listWorkspaceStorageAccountKeysPlain
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ContainerType
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetBatchDeploymentPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetBatchDeploymentPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetBatchEndpointPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetBatchEndpointPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetCapacityReservationGroupPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetCapacityReservationGroupPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetCodeContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetCodeContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetCodeVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetCodeVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComponentContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComponentContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComponentVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComponentVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComputeAllowedResizeSizesPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComputeAllowedResizeSizesPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComputePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetComputePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetDataContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetDataContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetDataVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetDataVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetDatastorePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetDatastorePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEndpointDeploymentPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEndpointDeploymentPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEnvironmentContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEnvironmentContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEnvironmentSpecificationVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEnvironmentSpecificationVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEnvironmentVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetEnvironmentVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturesetContainerEntityPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturesetContainerEntityPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturesetVersionFeaturePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturesetVersionFeaturePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturesetVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturesetVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturestoreEntityContainerEntityPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturestoreEntityContainerEntityPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturestoreEntityVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetFeaturestoreEntityVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferenceEndpointPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferenceEndpointPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferenceGroupPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferenceGroupPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferenceGroupStatusPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferenceGroupStatusPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferencePoolPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferencePoolPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferencePoolStatusPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetInferencePoolStatusPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetJobPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetJobPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetLabelingJobPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetLabelingJobPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetLinkedServicePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetLinkedServicePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetLinkedWorkspacePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetLinkedWorkspacePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetMachineLearningDatasetPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetMachineLearningDatasetPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetMachineLearningDatastorePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetMachineLearningDatastorePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetManagedNetworkSettingsRulePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetManagedNetworkSettingsRulePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetMarketplaceSubscriptionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetMarketplaceSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetModelContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetModelContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetModelVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetModelVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineDeploymentLogsPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineDeploymentLogsPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineDeploymentPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineDeploymentPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineEndpointPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineEndpointPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineEndpointTokenPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetOnlineEndpointTokenPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryCodeContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryCodeContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryCodeVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryCodeVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryComponentContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryComponentContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryComponentVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryComponentVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryDataContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryDataContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryDataVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryDataVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryEnvironmentContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryEnvironmentContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryEnvironmentVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryEnvironmentVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryModelContainerPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryModelContainerPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryModelVersionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryModelVersionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetRegistryPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetSchedulePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetSchedulePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetServerlessEndpointPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetServerlessEndpointPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetServerlessEndpointStatusPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetServerlessEndpointStatusPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetWorkspaceConnectionPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetWorkspaceConnectionPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListBatchEndpointKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListBatchEndpointKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListComputeKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListComputeKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListComputeNodesPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListComputeNodesPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListDatastoreSecretsPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListDatastoreSecretsPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListEndpointKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListEndpointKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListFeaturesetVersionFeaturesPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListFeaturesetVersionFeaturesPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListFeaturesetVersionMaterializationJobsPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListFeaturesetVersionMaterializationJobsPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListOnlineEndpointKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListOnlineEndpointKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListServerlessEndpointKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListServerlessEndpointKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceConnectionSecretsPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceConnectionSecretsPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceNotebookAccessTokenPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceNotebookAccessTokenPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceNotebookKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceNotebookKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceStorageAccountKeysPlainArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ListWorkspaceStorageAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetBatchDeploymentResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetBatchEndpointResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetCapacityReservationGroupResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetCodeContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetCodeVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComponentContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComponentVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComputeAllowedResizeSizesResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComputeResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetDataContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetDataVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetDatastoreResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEndpointDeploymentResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEnvironmentContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEnvironmentSpecificationVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEnvironmentVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturesetContainerEntityResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturesetVersionFeatureResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturesetVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturestoreEntityContainerEntityResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturestoreEntityVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferenceEndpointResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferenceGroupResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferenceGroupStatusResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferencePoolResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferencePoolStatusResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetJobResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetLabelingJobResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetLinkedServiceResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetLinkedWorkspaceResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetMachineLearningDatasetResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetMachineLearningDatastoreResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetManagedNetworkSettingsRuleResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetMarketplaceSubscriptionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetModelContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetModelVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineDeploymentLogsResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineDeploymentResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineEndpointResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineEndpointTokenResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryCodeContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryCodeVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryComponentContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryComponentVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryDataContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryDataVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryEnvironmentContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryEnvironmentVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryModelContainerResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryModelVersionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetScheduleResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetServerlessEndpointResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetServerlessEndpointStatusResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetWorkspaceConnectionResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetWorkspaceResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListBatchEndpointKeysResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListComputeKeysResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListComputeNodesResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListDatastoreSecretsResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListEndpointKeysResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListFeaturesetVersionFeaturesResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListFeaturesetVersionMaterializationJobsResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListOnlineEndpointKeysResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListServerlessEndpointKeysResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceConnectionSecretsResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceKeysResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceNotebookAccessTokenResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceNotebookKeysResult
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceStorageAccountKeysResult
import com.pulumi.core.Either
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetBatchDeploymentResult.Companion.toKotlin as getBatchDeploymentResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetBatchEndpointResult.Companion.toKotlin as getBatchEndpointResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetCapacityReservationGroupResult.Companion.toKotlin as getCapacityReservationGroupResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetCodeContainerResult.Companion.toKotlin as getCodeContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetCodeVersionResult.Companion.toKotlin as getCodeVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComponentContainerResult.Companion.toKotlin as getComponentContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComponentVersionResult.Companion.toKotlin as getComponentVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComputeAllowedResizeSizesResult.Companion.toKotlin as getComputeAllowedResizeSizesResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetComputeResult.Companion.toKotlin as getComputeResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetDataContainerResult.Companion.toKotlin as getDataContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetDataVersionResult.Companion.toKotlin as getDataVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetDatastoreResult.Companion.toKotlin as getDatastoreResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEndpointDeploymentResult.Companion.toKotlin as getEndpointDeploymentResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEnvironmentContainerResult.Companion.toKotlin as getEnvironmentContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEnvironmentSpecificationVersionResult.Companion.toKotlin as getEnvironmentSpecificationVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetEnvironmentVersionResult.Companion.toKotlin as getEnvironmentVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturesetContainerEntityResult.Companion.toKotlin as getFeaturesetContainerEntityResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturesetVersionFeatureResult.Companion.toKotlin as getFeaturesetVersionFeatureResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturesetVersionResult.Companion.toKotlin as getFeaturesetVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturestoreEntityContainerEntityResult.Companion.toKotlin as getFeaturestoreEntityContainerEntityResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetFeaturestoreEntityVersionResult.Companion.toKotlin as getFeaturestoreEntityVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferenceEndpointResult.Companion.toKotlin as getInferenceEndpointResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferenceGroupResult.Companion.toKotlin as getInferenceGroupResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferenceGroupStatusResult.Companion.toKotlin as getInferenceGroupStatusResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferencePoolResult.Companion.toKotlin as getInferencePoolResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetInferencePoolStatusResult.Companion.toKotlin as getInferencePoolStatusResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetJobResult.Companion.toKotlin as getJobResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetLabelingJobResult.Companion.toKotlin as getLabelingJobResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetLinkedServiceResult.Companion.toKotlin as getLinkedServiceResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetLinkedWorkspaceResult.Companion.toKotlin as getLinkedWorkspaceResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetMachineLearningDatasetResult.Companion.toKotlin as getMachineLearningDatasetResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetMachineLearningDatastoreResult.Companion.toKotlin as getMachineLearningDatastoreResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetManagedNetworkSettingsRuleResult.Companion.toKotlin as getManagedNetworkSettingsRuleResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetMarketplaceSubscriptionResult.Companion.toKotlin as getMarketplaceSubscriptionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetModelContainerResult.Companion.toKotlin as getModelContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetModelVersionResult.Companion.toKotlin as getModelVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineDeploymentLogsResult.Companion.toKotlin as getOnlineDeploymentLogsResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineDeploymentResult.Companion.toKotlin as getOnlineDeploymentResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineEndpointResult.Companion.toKotlin as getOnlineEndpointResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetOnlineEndpointTokenResult.Companion.toKotlin as getOnlineEndpointTokenResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryCodeContainerResult.Companion.toKotlin as getRegistryCodeContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryCodeVersionResult.Companion.toKotlin as getRegistryCodeVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryComponentContainerResult.Companion.toKotlin as getRegistryComponentContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryComponentVersionResult.Companion.toKotlin as getRegistryComponentVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryDataContainerResult.Companion.toKotlin as getRegistryDataContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryDataVersionResult.Companion.toKotlin as getRegistryDataVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryEnvironmentContainerResult.Companion.toKotlin as getRegistryEnvironmentContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryEnvironmentVersionResult.Companion.toKotlin as getRegistryEnvironmentVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryModelContainerResult.Companion.toKotlin as getRegistryModelContainerResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryModelVersionResult.Companion.toKotlin as getRegistryModelVersionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetRegistryResult.Companion.toKotlin as getRegistryResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetScheduleResult.Companion.toKotlin as getScheduleResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetServerlessEndpointResult.Companion.toKotlin as getServerlessEndpointResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetServerlessEndpointStatusResult.Companion.toKotlin as getServerlessEndpointStatusResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetWorkspaceConnectionResult.Companion.toKotlin as getWorkspaceConnectionResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListBatchEndpointKeysResult.Companion.toKotlin as listBatchEndpointKeysResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListComputeKeysResult.Companion.toKotlin as listComputeKeysResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListComputeNodesResult.Companion.toKotlin as listComputeNodesResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListDatastoreSecretsResult.Companion.toKotlin as listDatastoreSecretsResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListEndpointKeysResult.Companion.toKotlin as listEndpointKeysResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListFeaturesetVersionFeaturesResult.Companion.toKotlin as listFeaturesetVersionFeaturesResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListFeaturesetVersionMaterializationJobsResult.Companion.toKotlin as listFeaturesetVersionMaterializationJobsResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListOnlineEndpointKeysResult.Companion.toKotlin as listOnlineEndpointKeysResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListServerlessEndpointKeysResult.Companion.toKotlin as listServerlessEndpointKeysResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceConnectionSecretsResult.Companion.toKotlin as listWorkspaceConnectionSecretsResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceKeysResult.Companion.toKotlin as listWorkspaceKeysResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceNotebookAccessTokenResult.Companion.toKotlin as listWorkspaceNotebookAccessTokenResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceNotebookKeysResult.Companion.toKotlin as listWorkspaceNotebookKeysResultToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ListWorkspaceStorageAccountKeysResult.Companion.toKotlin as listWorkspaceStorageAccountKeysResultToKotlin

public object MachinelearningservicesFunctions {
    /**
     *
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getBatchDeployment(argument: GetBatchDeploymentPlainArgs):
        GetBatchDeploymentResult =
        getBatchDeploymentResultToKotlin(getBatchDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getBatchDeployment].
     * @param deploymentName The identifier for the Batch deployments.
     * @param endpointName Endpoint name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getBatchDeployment(
        deploymentName: String,
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetBatchDeploymentResult {
        val argument = GetBatchDeploymentPlainArgs(
            deploymentName = deploymentName,
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getBatchDeploymentResultToKotlin(getBatchDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getBatchDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetBatchDeploymentPlainArgs].
     * @return null
     */
    public suspend
    fun getBatchDeployment(argument: suspend GetBatchDeploymentPlainArgsBuilder.() -> Unit):
        GetBatchDeploymentResult {
        val builder = GetBatchDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBatchDeploymentResultToKotlin(getBatchDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getBatchEndpoint(argument: GetBatchEndpointPlainArgs): GetBatchEndpointResult =
        getBatchEndpointResultToKotlin(getBatchEndpointPlain(argument.toJava()).await())

    /**
     * @see [getBatchEndpoint].
     * @param endpointName Name for the Batch Endpoint.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getBatchEndpoint(
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetBatchEndpointResult {
        val argument = GetBatchEndpointPlainArgs(
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getBatchEndpointResultToKotlin(getBatchEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getBatchEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetBatchEndpointPlainArgs].
     * @return null
     */
    public suspend
    fun getBatchEndpoint(argument: suspend GetBatchEndpointPlainArgsBuilder.() -> Unit):
        GetBatchEndpointResult {
        val builder = GetBatchEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBatchEndpointResultToKotlin(getBatchEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getCapacityReservationGroup(argument: GetCapacityReservationGroupPlainArgs):
        GetCapacityReservationGroupResult =
        getCapacityReservationGroupResultToKotlin(getCapacityReservationGroupPlain(argument.toJava()).await())

    /**
     * @see [getCapacityReservationGroup].
     * @param groupId
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getCapacityReservationGroup(groupId: String, resourceGroupName: String):
        GetCapacityReservationGroupResult {
        val argument = GetCapacityReservationGroupPlainArgs(
            groupId = groupId,
            resourceGroupName = resourceGroupName,
        )
        return getCapacityReservationGroupResultToKotlin(getCapacityReservationGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getCapacityReservationGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetCapacityReservationGroupPlainArgs].
     * @return null
     */
    public suspend
    fun getCapacityReservationGroup(argument: suspend GetCapacityReservationGroupPlainArgsBuilder.() -> Unit):
        GetCapacityReservationGroupResult {
        val builder = GetCapacityReservationGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCapacityReservationGroupResultToKotlin(getCapacityReservationGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getCodeContainer(argument: GetCodeContainerPlainArgs): GetCodeContainerResult =
        getCodeContainerResultToKotlin(getCodeContainerPlain(argument.toJava()).await())

    /**
     * @see [getCodeContainer].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getCodeContainer(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetCodeContainerResult {
        val argument = GetCodeContainerPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getCodeContainerResultToKotlin(getCodeContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getCodeContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetCodeContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getCodeContainer(argument: suspend GetCodeContainerPlainArgsBuilder.() -> Unit):
        GetCodeContainerResult {
        val builder = GetCodeContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCodeContainerResultToKotlin(getCodeContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getCodeVersion(argument: GetCodeVersionPlainArgs): GetCodeVersionResult =
        getCodeVersionResultToKotlin(getCodeVersionPlain(argument.toJava()).await())

    /**
     * @see [getCodeVersion].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getCodeVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetCodeVersionResult {
        val argument = GetCodeVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getCodeVersionResultToKotlin(getCodeVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getCodeVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetCodeVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getCodeVersion(argument: suspend GetCodeVersionPlainArgsBuilder.() -> Unit):
        GetCodeVersionResult {
        val builder = GetCodeVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCodeVersionResultToKotlin(getCodeVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getComponentContainer(argument: GetComponentContainerPlainArgs):
        GetComponentContainerResult =
        getComponentContainerResultToKotlin(getComponentContainerPlain(argument.toJava()).await())

    /**
     * @see [getComponentContainer].
     * @param name Container name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getComponentContainer(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetComponentContainerResult {
        val argument = GetComponentContainerPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getComponentContainerResultToKotlin(getComponentContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getComponentContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetComponentContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getComponentContainer(argument: suspend GetComponentContainerPlainArgsBuilder.() -> Unit):
        GetComponentContainerResult {
        val builder = GetComponentContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComponentContainerResultToKotlin(getComponentContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getComponentVersion(argument: GetComponentVersionPlainArgs):
        GetComponentVersionResult =
        getComponentVersionResultToKotlin(getComponentVersionPlain(argument.toJava()).await())

    /**
     * @see [getComponentVersion].
     * @param name Container name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getComponentVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetComponentVersionResult {
        val argument = GetComponentVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getComponentVersionResultToKotlin(getComponentVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getComponentVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetComponentVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getComponentVersion(argument: suspend GetComponentVersionPlainArgsBuilder.() -> Unit):
        GetComponentVersionResult {
        val builder = GetComponentVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComponentVersionResultToKotlin(getComponentVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets compute definition by its name. Any secrets (storage keys, service credentials, etc) are not returned - use 'keys' nested resource to get them.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Machine Learning compute object wrapped into ARM resource envelope.
     */
    public suspend fun getCompute(argument: GetComputePlainArgs): GetComputeResult =
        getComputeResultToKotlin(getComputePlain(argument.toJava()).await())

    /**
     * @see [getCompute].
     * @param computeName Name of the Azure Machine Learning compute.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Machine Learning compute object wrapped into ARM resource envelope.
     */
    public suspend fun getCompute(
        computeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetComputeResult {
        val argument = GetComputePlainArgs(
            computeName = computeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getComputeResultToKotlin(getComputePlain(argument.toJava()).await())
    }

    /**
     * @see [getCompute].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetComputePlainArgs].
     * @return Machine Learning compute object wrapped into ARM resource envelope.
     */
    public suspend fun getCompute(argument: suspend GetComputePlainArgsBuilder.() -> Unit):
        GetComputeResult {
        val builder = GetComputePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComputeResultToKotlin(getComputePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns supported virtual machine sizes for resize
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return The List Virtual Machine size operation response.
     */
    public suspend fun getComputeAllowedResizeSizes(argument: GetComputeAllowedResizeSizesPlainArgs):
        GetComputeAllowedResizeSizesResult =
        getComputeAllowedResizeSizesResultToKotlin(getComputeAllowedResizeSizesPlain(argument.toJava()).await())

    /**
     * @see [getComputeAllowedResizeSizes].
     * @param computeName Name of the Azure Machine Learning compute.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return The List Virtual Machine size operation response.
     */
    public suspend fun getComputeAllowedResizeSizes(
        computeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetComputeAllowedResizeSizesResult {
        val argument = GetComputeAllowedResizeSizesPlainArgs(
            computeName = computeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getComputeAllowedResizeSizesResultToKotlin(getComputeAllowedResizeSizesPlain(argument.toJava()).await())
    }

    /**
     * @see [getComputeAllowedResizeSizes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetComputeAllowedResizeSizesPlainArgs].
     * @return The List Virtual Machine size operation response.
     */
    public suspend
    fun getComputeAllowedResizeSizes(argument: suspend GetComputeAllowedResizeSizesPlainArgsBuilder.() -> Unit):
        GetComputeAllowedResizeSizesResult {
        val builder = GetComputeAllowedResizeSizesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComputeAllowedResizeSizesResultToKotlin(getComputeAllowedResizeSizesPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDataContainer(argument: GetDataContainerPlainArgs): GetDataContainerResult =
        getDataContainerResultToKotlin(getDataContainerPlain(argument.toJava()).await())

    /**
     * @see [getDataContainer].
     * @param name Container name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDataContainer(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetDataContainerResult {
        val argument = GetDataContainerPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getDataContainerResultToKotlin(getDataContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetDataContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getDataContainer(argument: suspend GetDataContainerPlainArgsBuilder.() -> Unit):
        GetDataContainerResult {
        val builder = GetDataContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataContainerResultToKotlin(getDataContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDataVersion(argument: GetDataVersionPlainArgs): GetDataVersionResult =
        getDataVersionResultToKotlin(getDataVersionPlain(argument.toJava()).await())

    /**
     * @see [getDataVersion].
     * @param name Container name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDataVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetDataVersionResult {
        val argument = GetDataVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getDataVersionResultToKotlin(getDataVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetDataVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDataVersion(argument: suspend GetDataVersionPlainArgsBuilder.() -> Unit):
        GetDataVersionResult {
        val builder = GetDataVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataVersionResultToKotlin(getDataVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDatastore(argument: GetDatastorePlainArgs): GetDatastoreResult =
        getDatastoreResultToKotlin(getDatastorePlain(argument.toJava()).await())

    /**
     * @see [getDatastore].
     * @param name Datastore name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDatastore(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetDatastoreResult {
        val argument = GetDatastorePlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getDatastoreResultToKotlin(getDatastorePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatastore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetDatastorePlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getDatastore(argument: suspend GetDatastorePlainArgsBuilder.() -> Unit):
        GetDatastoreResult {
        val builder = GetDatastorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatastoreResultToKotlin(getDatastorePlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getEndpointDeployment(argument: GetEndpointDeploymentPlainArgs):
        GetEndpointDeploymentResult =
        getEndpointDeploymentResultToKotlin(getEndpointDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getEndpointDeployment].
     * @param deploymentName Name of the deployment resource
     * @param endpointName Name of the endpoint resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Azure Machine Learning Workspace Name
     * @return null
     */
    public suspend fun getEndpointDeployment(
        deploymentName: String,
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetEndpointDeploymentResult {
        val argument = GetEndpointDeploymentPlainArgs(
            deploymentName = deploymentName,
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getEndpointDeploymentResultToKotlin(getEndpointDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpointDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetEndpointDeploymentPlainArgs].
     * @return null
     */
    public suspend
    fun getEndpointDeployment(argument: suspend GetEndpointDeploymentPlainArgsBuilder.() -> Unit):
        GetEndpointDeploymentResult {
        val builder = GetEndpointDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointDeploymentResultToKotlin(getEndpointDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getEnvironmentContainer(argument: GetEnvironmentContainerPlainArgs):
        GetEnvironmentContainerResult =
        getEnvironmentContainerResultToKotlin(getEnvironmentContainerPlain(argument.toJava()).await())

    /**
     * @see [getEnvironmentContainer].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getEnvironmentContainer(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetEnvironmentContainerResult {
        val argument = GetEnvironmentContainerPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getEnvironmentContainerResultToKotlin(getEnvironmentContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironmentContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetEnvironmentContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getEnvironmentContainer(argument: suspend GetEnvironmentContainerPlainArgsBuilder.() -> Unit):
        GetEnvironmentContainerResult {
        val builder = GetEnvironmentContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentContainerResultToKotlin(getEnvironmentContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2021-03-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getEnvironmentSpecificationVersion(argument: GetEnvironmentSpecificationVersionPlainArgs):
        GetEnvironmentSpecificationVersionResult =
        getEnvironmentSpecificationVersionResultToKotlin(getEnvironmentSpecificationVersionPlain(argument.toJava()).await())

    /**
     * @see [getEnvironmentSpecificationVersion].
     * @param name Container name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getEnvironmentSpecificationVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetEnvironmentSpecificationVersionResult {
        val argument = GetEnvironmentSpecificationVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getEnvironmentSpecificationVersionResultToKotlin(getEnvironmentSpecificationVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironmentSpecificationVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetEnvironmentSpecificationVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getEnvironmentSpecificationVersion(argument: suspend GetEnvironmentSpecificationVersionPlainArgsBuilder.() -> Unit):
        GetEnvironmentSpecificationVersionResult {
        val builder = GetEnvironmentSpecificationVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentSpecificationVersionResultToKotlin(getEnvironmentSpecificationVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getEnvironmentVersion(argument: GetEnvironmentVersionPlainArgs):
        GetEnvironmentVersionResult =
        getEnvironmentVersionResultToKotlin(getEnvironmentVersionPlain(argument.toJava()).await())

    /**
     * @see [getEnvironmentVersion].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getEnvironmentVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetEnvironmentVersionResult {
        val argument = GetEnvironmentVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getEnvironmentVersionResultToKotlin(getEnvironmentVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEnvironmentVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetEnvironmentVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getEnvironmentVersion(argument: suspend GetEnvironmentVersionPlainArgsBuilder.() -> Unit):
        GetEnvironmentVersionResult {
        val builder = GetEnvironmentVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEnvironmentVersionResultToKotlin(getEnvironmentVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getFeaturesetContainerEntity(argument: GetFeaturesetContainerEntityPlainArgs):
        GetFeaturesetContainerEntityResult =
        getFeaturesetContainerEntityResultToKotlin(getFeaturesetContainerEntityPlain(argument.toJava()).await())

    /**
     * @see [getFeaturesetContainerEntity].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getFeaturesetContainerEntity(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetFeaturesetContainerEntityResult {
        val argument = GetFeaturesetContainerEntityPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getFeaturesetContainerEntityResultToKotlin(getFeaturesetContainerEntityPlain(argument.toJava()).await())
    }

    /**
     * @see [getFeaturesetContainerEntity].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetFeaturesetContainerEntityPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getFeaturesetContainerEntity(argument: suspend GetFeaturesetContainerEntityPlainArgsBuilder.() -> Unit):
        GetFeaturesetContainerEntityResult {
        val builder = GetFeaturesetContainerEntityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFeaturesetContainerEntityResultToKotlin(getFeaturesetContainerEntityPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getFeaturesetVersion(argument: GetFeaturesetVersionPlainArgs):
        GetFeaturesetVersionResult =
        getFeaturesetVersionResultToKotlin(getFeaturesetVersionPlain(argument.toJava()).await())

    /**
     * @see [getFeaturesetVersion].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getFeaturesetVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetFeaturesetVersionResult {
        val argument = GetFeaturesetVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getFeaturesetVersionResultToKotlin(getFeaturesetVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getFeaturesetVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetFeaturesetVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getFeaturesetVersion(argument: suspend GetFeaturesetVersionPlainArgsBuilder.() -> Unit):
        GetFeaturesetVersionResult {
        val builder = GetFeaturesetVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFeaturesetVersionResultToKotlin(getFeaturesetVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Dto object representing feature
     * Azure REST API version: 2023-02-01-preview.
     * @param argument null
     * @return Dto object representing feature
     */
    public suspend fun getFeaturesetVersionFeature(argument: GetFeaturesetVersionFeaturePlainArgs):
        GetFeaturesetVersionFeatureResult =
        getFeaturesetVersionFeatureResultToKotlin(getFeaturesetVersionFeaturePlain(argument.toJava()).await())

    /**
     * @see [getFeaturesetVersionFeature].
     * @param featureName Specifies name of the feature.
     * @param name Feature set name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Feature set version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Dto object representing feature
     */
    public suspend fun getFeaturesetVersionFeature(
        featureName: String? = null,
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetFeaturesetVersionFeatureResult {
        val argument = GetFeaturesetVersionFeaturePlainArgs(
            featureName = featureName,
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getFeaturesetVersionFeatureResultToKotlin(getFeaturesetVersionFeaturePlain(argument.toJava()).await())
    }

    /**
     * @see [getFeaturesetVersionFeature].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetFeaturesetVersionFeaturePlainArgs].
     * @return Dto object representing feature
     */
    public suspend
    fun getFeaturesetVersionFeature(argument: suspend GetFeaturesetVersionFeaturePlainArgsBuilder.() -> Unit):
        GetFeaturesetVersionFeatureResult {
        val builder = GetFeaturesetVersionFeaturePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFeaturesetVersionFeatureResultToKotlin(getFeaturesetVersionFeaturePlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getFeaturestoreEntityContainerEntity(argument: GetFeaturestoreEntityContainerEntityPlainArgs):
        GetFeaturestoreEntityContainerEntityResult =
        getFeaturestoreEntityContainerEntityResultToKotlin(getFeaturestoreEntityContainerEntityPlain(argument.toJava()).await())

    /**
     * @see [getFeaturestoreEntityContainerEntity].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getFeaturestoreEntityContainerEntity(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetFeaturestoreEntityContainerEntityResult {
        val argument = GetFeaturestoreEntityContainerEntityPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getFeaturestoreEntityContainerEntityResultToKotlin(getFeaturestoreEntityContainerEntityPlain(argument.toJava()).await())
    }

    /**
     * @see [getFeaturestoreEntityContainerEntity].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetFeaturestoreEntityContainerEntityPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getFeaturestoreEntityContainerEntity(argument: suspend GetFeaturestoreEntityContainerEntityPlainArgsBuilder.() -> Unit):
        GetFeaturestoreEntityContainerEntityResult {
        val builder = GetFeaturestoreEntityContainerEntityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFeaturestoreEntityContainerEntityResultToKotlin(getFeaturestoreEntityContainerEntityPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getFeaturestoreEntityVersion(argument: GetFeaturestoreEntityVersionPlainArgs):
        GetFeaturestoreEntityVersionResult =
        getFeaturestoreEntityVersionResultToKotlin(getFeaturestoreEntityVersionPlain(argument.toJava()).await())

    /**
     * @see [getFeaturestoreEntityVersion].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getFeaturestoreEntityVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetFeaturestoreEntityVersionResult {
        val argument = GetFeaturestoreEntityVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getFeaturestoreEntityVersionResultToKotlin(getFeaturestoreEntityVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getFeaturestoreEntityVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetFeaturestoreEntityVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getFeaturestoreEntityVersion(argument: suspend GetFeaturestoreEntityVersionPlainArgsBuilder.() -> Unit):
        GetFeaturestoreEntityVersionResult {
        val builder = GetFeaturestoreEntityVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFeaturestoreEntityVersionResultToKotlin(getFeaturestoreEntityVersionPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getInferenceEndpoint(argument: GetInferenceEndpointPlainArgs):
        GetInferenceEndpointResult =
        getInferenceEndpointResultToKotlin(getInferenceEndpointPlain(argument.toJava()).await())

    /**
     * @see [getInferenceEndpoint].
     * @param endpointName InferenceEndpoint name.
     * @param poolName InferencePool name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getInferenceEndpoint(
        endpointName: String,
        poolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetInferenceEndpointResult {
        val argument = GetInferenceEndpointPlainArgs(
            endpointName = endpointName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getInferenceEndpointResultToKotlin(getInferenceEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getInferenceEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetInferenceEndpointPlainArgs].
     * @return null
     */
    public suspend
    fun getInferenceEndpoint(argument: suspend GetInferenceEndpointPlainArgsBuilder.() -> Unit):
        GetInferenceEndpointResult {
        val builder = GetInferenceEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInferenceEndpointResultToKotlin(getInferenceEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getInferenceGroup(argument: GetInferenceGroupPlainArgs):
        GetInferenceGroupResult =
        getInferenceGroupResultToKotlin(getInferenceGroupPlain(argument.toJava()).await())

    /**
     * @see [getInferenceGroup].
     * @param groupName InferenceGroup name.
     * @param poolName InferencePool name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getInferenceGroup(
        groupName: String,
        poolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetInferenceGroupResult {
        val argument = GetInferenceGroupPlainArgs(
            groupName = groupName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getInferenceGroupResultToKotlin(getInferenceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getInferenceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetInferenceGroupPlainArgs].
     * @return null
     */
    public suspend
    fun getInferenceGroup(argument: suspend GetInferenceGroupPlainArgsBuilder.() -> Unit):
        GetInferenceGroupResult {
        val builder = GetInferenceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInferenceGroupResultToKotlin(getInferenceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getInferenceGroupStatus(argument: GetInferenceGroupStatusPlainArgs):
        GetInferenceGroupStatusResult =
        getInferenceGroupStatusResultToKotlin(getInferenceGroupStatusPlain(argument.toJava()).await())

    /**
     * @see [getInferenceGroupStatus].
     * @param groupName InferenceGroup name.
     * @param poolName InferencePool name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getInferenceGroupStatus(
        groupName: String,
        poolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetInferenceGroupStatusResult {
        val argument = GetInferenceGroupStatusPlainArgs(
            groupName = groupName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getInferenceGroupStatusResultToKotlin(getInferenceGroupStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getInferenceGroupStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetInferenceGroupStatusPlainArgs].
     * @return null
     */
    public suspend
    fun getInferenceGroupStatus(argument: suspend GetInferenceGroupStatusPlainArgsBuilder.() -> Unit):
        GetInferenceGroupStatusResult {
        val builder = GetInferenceGroupStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInferenceGroupStatusResultToKotlin(getInferenceGroupStatusPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getInferencePool(argument: GetInferencePoolPlainArgs): GetInferencePoolResult =
        getInferencePoolResultToKotlin(getInferencePoolPlain(argument.toJava()).await())

    /**
     * @see [getInferencePool].
     * @param inferencePoolName Name of InferencePool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getInferencePool(
        inferencePoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetInferencePoolResult {
        val argument = GetInferencePoolPlainArgs(
            inferencePoolName = inferencePoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getInferencePoolResultToKotlin(getInferencePoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getInferencePool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetInferencePoolPlainArgs].
     * @return null
     */
    public suspend
    fun getInferencePool(argument: suspend GetInferencePoolPlainArgsBuilder.() -> Unit):
        GetInferencePoolResult {
        val builder = GetInferencePoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInferencePoolResultToKotlin(getInferencePoolPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getInferencePoolStatus(argument: GetInferencePoolStatusPlainArgs):
        GetInferencePoolStatusResult =
        getInferencePoolStatusResultToKotlin(getInferencePoolStatusPlain(argument.toJava()).await())

    /**
     * @see [getInferencePoolStatus].
     * @param inferencePoolName Name of InferencePool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getInferencePoolStatus(
        inferencePoolName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetInferencePoolStatusResult {
        val argument = GetInferencePoolStatusPlainArgs(
            inferencePoolName = inferencePoolName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getInferencePoolStatusResultToKotlin(getInferencePoolStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getInferencePoolStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetInferencePoolStatusPlainArgs].
     * @return null
     */
    public suspend
    fun getInferencePoolStatus(argument: suspend GetInferencePoolStatusPlainArgsBuilder.() -> Unit):
        GetInferencePoolStatusResult {
        val builder = GetInferencePoolStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInferencePoolStatusResultToKotlin(getInferencePoolStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getJob(argument: GetJobPlainArgs): GetJobResult =
        getJobResultToKotlin(getJobPlain(argument.toJava()).await())

    /**
     * @see [getJob].
     * @param id The name and identifier for the Job. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getJob(
        id: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetJobResult {
        val argument = GetJobPlainArgs(
            id = id,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getJobResultToKotlin(getJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getJob].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetJobPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getJob(argument: suspend GetJobPlainArgsBuilder.() -> Unit): GetJobResult {
        val builder = GetJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobResultToKotlin(getJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2020-09-01-preview, 2021-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getLabelingJob(argument: GetLabelingJobPlainArgs): GetLabelingJobResult =
        getLabelingJobResultToKotlin(getLabelingJobPlain(argument.toJava()).await())

    /**
     * @see [getLabelingJob].
     * @param id The name and identifier for the LabelingJob.
     * @param includeJobInstructions Boolean value to indicate whether to include JobInstructions in response.
     * @param includeLabelCategories Boolean value to indicate Whether to include LabelCategories in response.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getLabelingJob(
        id: String,
        includeJobInstructions: Boolean? = null,
        includeLabelCategories: Boolean? = null,
        resourceGroupName: String,
        workspaceName: String,
    ): GetLabelingJobResult {
        val argument = GetLabelingJobPlainArgs(
            id = id,
            includeJobInstructions = includeJobInstructions,
            includeLabelCategories = includeLabelCategories,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getLabelingJobResultToKotlin(getLabelingJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getLabelingJob].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetLabelingJobPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getLabelingJob(argument: suspend GetLabelingJobPlainArgsBuilder.() -> Unit):
        GetLabelingJobResult {
        val builder = GetLabelingJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabelingJobResultToKotlin(getLabelingJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the detail of a linked service.
     * Azure REST API version: 2020-09-01-preview.
     * @param argument null
     * @return Linked service.
     */
    public suspend fun getLinkedService(argument: GetLinkedServicePlainArgs): GetLinkedServiceResult =
        getLinkedServiceResultToKotlin(getLinkedServicePlain(argument.toJava()).await())

    /**
     * @see [getLinkedService].
     * @param linkName Friendly name of the linked workspace
     * @param resourceGroupName Name of the resource group in which workspace is located.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Linked service.
     */
    public suspend fun getLinkedService(
        linkName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetLinkedServiceResult {
        val argument = GetLinkedServicePlainArgs(
            linkName = linkName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getLinkedServiceResultToKotlin(getLinkedServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkedService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetLinkedServicePlainArgs].
     * @return Linked service.
     */
    public suspend
    fun getLinkedService(argument: suspend GetLinkedServicePlainArgsBuilder.() -> Unit):
        GetLinkedServiceResult {
        val builder = GetLinkedServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkedServiceResultToKotlin(getLinkedServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the detail of a linked workspace.
     * Azure REST API version: 2020-05-15-preview.
     * @param argument null
     * @return Linked workspace.
     */
    public suspend fun getLinkedWorkspace(argument: GetLinkedWorkspacePlainArgs):
        GetLinkedWorkspaceResult =
        getLinkedWorkspaceResultToKotlin(getLinkedWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getLinkedWorkspace].
     * @param linkName Friendly name of the linked workspace
     * @param resourceGroupName Name of the resource group in which workspace is located.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Linked workspace.
     */
    public suspend fun getLinkedWorkspace(
        linkName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetLinkedWorkspaceResult {
        val argument = GetLinkedWorkspacePlainArgs(
            linkName = linkName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getLinkedWorkspaceResultToKotlin(getLinkedWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkedWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetLinkedWorkspacePlainArgs].
     * @return Linked workspace.
     */
    public suspend
    fun getLinkedWorkspace(argument: suspend GetLinkedWorkspacePlainArgsBuilder.() -> Unit):
        GetLinkedWorkspaceResult {
        val builder = GetLinkedWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkedWorkspaceResultToKotlin(getLinkedWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Dataset by name.
     * Azure REST API version: 2020-05-01-preview.
     * @param argument null
     * @return Machine Learning dataset object wrapped into ARM resource envelope.
     */
    public suspend fun getMachineLearningDataset(argument: GetMachineLearningDatasetPlainArgs):
        GetMachineLearningDatasetResult =
        getMachineLearningDatasetResultToKotlin(getMachineLearningDatasetPlain(argument.toJava()).await())

    /**
     * @see [getMachineLearningDataset].
     * @param datasetName The Dataset name.
     * @param resourceGroupName Name of the resource group in which workspace is located.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Machine Learning dataset object wrapped into ARM resource envelope.
     */
    public suspend fun getMachineLearningDataset(
        datasetName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetMachineLearningDatasetResult {
        val argument = GetMachineLearningDatasetPlainArgs(
            datasetName = datasetName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getMachineLearningDatasetResultToKotlin(getMachineLearningDatasetPlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineLearningDataset].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetMachineLearningDatasetPlainArgs].
     * @return Machine Learning dataset object wrapped into ARM resource envelope.
     */
    public suspend
    fun getMachineLearningDataset(argument: suspend GetMachineLearningDatasetPlainArgsBuilder.() -> Unit):
        GetMachineLearningDatasetResult {
        val builder = GetMachineLearningDatasetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineLearningDatasetResultToKotlin(getMachineLearningDatasetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Datastore by name.
     * Azure REST API version: 2020-05-01-preview.
     * @param argument null
     * @return Machine Learning datastore object wrapped into ARM resource envelope.
     */
    public suspend fun getMachineLearningDatastore(argument: GetMachineLearningDatastorePlainArgs):
        GetMachineLearningDatastoreResult =
        getMachineLearningDatastoreResultToKotlin(getMachineLearningDatastorePlain(argument.toJava()).await())

    /**
     * @see [getMachineLearningDatastore].
     * @param datastoreName The Datastore name.
     * @param resourceGroupName Name of the resource group in which workspace is located.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Machine Learning datastore object wrapped into ARM resource envelope.
     */
    public suspend fun getMachineLearningDatastore(
        datastoreName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetMachineLearningDatastoreResult {
        val argument = GetMachineLearningDatastorePlainArgs(
            datastoreName = datastoreName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getMachineLearningDatastoreResultToKotlin(getMachineLearningDatastorePlain(argument.toJava()).await())
    }

    /**
     * @see [getMachineLearningDatastore].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetMachineLearningDatastorePlainArgs].
     * @return Machine Learning datastore object wrapped into ARM resource envelope.
     */
    public suspend
    fun getMachineLearningDatastore(argument: suspend GetMachineLearningDatastorePlainArgsBuilder.() -> Unit):
        GetMachineLearningDatastoreResult {
        val builder = GetMachineLearningDatastorePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMachineLearningDatastoreResultToKotlin(getMachineLearningDatastorePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an outbound rule from the managed network of a machine learning workspace.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Outbound Rule Basic Resource for the managed network of a machine learning workspace.
     */
    public suspend
    fun getManagedNetworkSettingsRule(argument: GetManagedNetworkSettingsRulePlainArgs):
        GetManagedNetworkSettingsRuleResult =
        getManagedNetworkSettingsRuleResultToKotlin(getManagedNetworkSettingsRulePlain(argument.toJava()).await())

    /**
     * @see [getManagedNetworkSettingsRule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param ruleName Name of the workspace managed network outbound rule
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Outbound Rule Basic Resource for the managed network of a machine learning workspace.
     */
    public suspend fun getManagedNetworkSettingsRule(
        resourceGroupName: String,
        ruleName: String,
        workspaceName: String,
    ): GetManagedNetworkSettingsRuleResult {
        val argument = GetManagedNetworkSettingsRulePlainArgs(
            resourceGroupName = resourceGroupName,
            ruleName = ruleName,
            workspaceName = workspaceName,
        )
        return getManagedNetworkSettingsRuleResultToKotlin(getManagedNetworkSettingsRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedNetworkSettingsRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetManagedNetworkSettingsRulePlainArgs].
     * @return Outbound Rule Basic Resource for the managed network of a machine learning workspace.
     */
    public suspend
    fun getManagedNetworkSettingsRule(argument: suspend GetManagedNetworkSettingsRulePlainArgsBuilder.() -> Unit):
        GetManagedNetworkSettingsRuleResult {
        val builder = GetManagedNetworkSettingsRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedNetworkSettingsRuleResultToKotlin(getManagedNetworkSettingsRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getMarketplaceSubscription(argument: GetMarketplaceSubscriptionPlainArgs):
        GetMarketplaceSubscriptionResult =
        getMarketplaceSubscriptionResultToKotlin(getMarketplaceSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [getMarketplaceSubscription].
     * @param name Container name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getMarketplaceSubscription(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetMarketplaceSubscriptionResult {
        val argument = GetMarketplaceSubscriptionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getMarketplaceSubscriptionResultToKotlin(getMarketplaceSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getMarketplaceSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetMarketplaceSubscriptionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getMarketplaceSubscription(argument: suspend GetMarketplaceSubscriptionPlainArgsBuilder.() -> Unit):
        GetMarketplaceSubscriptionResult {
        val builder = GetMarketplaceSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMarketplaceSubscriptionResultToKotlin(getMarketplaceSubscriptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getModelContainer(argument: GetModelContainerPlainArgs):
        GetModelContainerResult =
        getModelContainerResultToKotlin(getModelContainerPlain(argument.toJava()).await())

    /**
     * @see [getModelContainer].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getModelContainer(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetModelContainerResult {
        val argument = GetModelContainerPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getModelContainerResultToKotlin(getModelContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getModelContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetModelContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getModelContainer(argument: suspend GetModelContainerPlainArgsBuilder.() -> Unit):
        GetModelContainerResult {
        val builder = GetModelContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModelContainerResultToKotlin(getModelContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getModelVersion(argument: GetModelVersionPlainArgs): GetModelVersionResult =
        getModelVersionResultToKotlin(getModelVersionPlain(argument.toJava()).await())

    /**
     * @see [getModelVersion].
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getModelVersion(
        name: String,
        resourceGroupName: String,
        version: String,
        workspaceName: String,
    ): GetModelVersionResult {
        val argument = GetModelVersionPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            version = version,
            workspaceName = workspaceName,
        )
        return getModelVersionResultToKotlin(getModelVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getModelVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetModelVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getModelVersion(argument: suspend GetModelVersionPlainArgsBuilder.() -> Unit):
        GetModelVersionResult {
        val builder = GetModelVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getModelVersionResultToKotlin(getModelVersionPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getOnlineDeployment(argument: GetOnlineDeploymentPlainArgs):
        GetOnlineDeploymentResult =
        getOnlineDeploymentResultToKotlin(getOnlineDeploymentPlain(argument.toJava()).await())

    /**
     * @see [getOnlineDeployment].
     * @param deploymentName Inference Endpoint Deployment name.
     * @param endpointName Inference endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getOnlineDeployment(
        deploymentName: String,
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetOnlineDeploymentResult {
        val argument = GetOnlineDeploymentPlainArgs(
            deploymentName = deploymentName,
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getOnlineDeploymentResultToKotlin(getOnlineDeploymentPlain(argument.toJava()).await())
    }

    /**
     * @see [getOnlineDeployment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetOnlineDeploymentPlainArgs].
     * @return null
     */
    public suspend
    fun getOnlineDeployment(argument: suspend GetOnlineDeploymentPlainArgsBuilder.() -> Unit):
        GetOnlineDeploymentResult {
        val builder = GetOnlineDeploymentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOnlineDeploymentResultToKotlin(getOnlineDeploymentPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getOnlineDeploymentLogs(argument: GetOnlineDeploymentLogsPlainArgs):
        GetOnlineDeploymentLogsResult =
        getOnlineDeploymentLogsResultToKotlin(getOnlineDeploymentLogsPlain(argument.toJava()).await())

    /**
     * @see [getOnlineDeploymentLogs].
     * @param containerType The type of container to retrieve logs from.
     * @param deploymentName The name and identifier for the endpoint.
     * @param endpointName Inference endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param tail The maximum number of lines to tail.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getOnlineDeploymentLogs(
        containerType: Either<String, ContainerType>? = null,
        deploymentName: String,
        endpointName: String,
        resourceGroupName: String,
        tail: Int? = null,
        workspaceName: String,
    ): GetOnlineDeploymentLogsResult {
        val argument = GetOnlineDeploymentLogsPlainArgs(
            containerType = containerType,
            deploymentName = deploymentName,
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            tail = tail,
            workspaceName = workspaceName,
        )
        return getOnlineDeploymentLogsResultToKotlin(getOnlineDeploymentLogsPlain(argument.toJava()).await())
    }

    /**
     * @see [getOnlineDeploymentLogs].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetOnlineDeploymentLogsPlainArgs].
     * @return null
     */
    public suspend
    fun getOnlineDeploymentLogs(argument: suspend GetOnlineDeploymentLogsPlainArgsBuilder.() -> Unit):
        GetOnlineDeploymentLogsResult {
        val builder = GetOnlineDeploymentLogsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOnlineDeploymentLogsResultToKotlin(getOnlineDeploymentLogsPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getOnlineEndpoint(argument: GetOnlineEndpointPlainArgs):
        GetOnlineEndpointResult =
        getOnlineEndpointResultToKotlin(getOnlineEndpointPlain(argument.toJava()).await())

    /**
     * @see [getOnlineEndpoint].
     * @param endpointName Online Endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getOnlineEndpoint(
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetOnlineEndpointResult {
        val argument = GetOnlineEndpointPlainArgs(
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getOnlineEndpointResultToKotlin(getOnlineEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getOnlineEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetOnlineEndpointPlainArgs].
     * @return null
     */
    public suspend
    fun getOnlineEndpoint(argument: suspend GetOnlineEndpointPlainArgsBuilder.() -> Unit):
        GetOnlineEndpointResult {
        val builder = GetOnlineEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOnlineEndpointResultToKotlin(getOnlineEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Service Token
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Service Token
     */
    public suspend fun getOnlineEndpointToken(argument: GetOnlineEndpointTokenPlainArgs):
        GetOnlineEndpointTokenResult =
        getOnlineEndpointTokenResultToKotlin(getOnlineEndpointTokenPlain(argument.toJava()).await())

    /**
     * @see [getOnlineEndpointToken].
     * @param endpointName Online Endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Service Token
     */
    public suspend fun getOnlineEndpointToken(
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetOnlineEndpointTokenResult {
        val argument = GetOnlineEndpointTokenPlainArgs(
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getOnlineEndpointTokenResultToKotlin(getOnlineEndpointTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getOnlineEndpointToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetOnlineEndpointTokenPlainArgs].
     * @return Service Token
     */
    public suspend
    fun getOnlineEndpointToken(argument: suspend GetOnlineEndpointTokenPlainArgsBuilder.() -> Unit):
        GetOnlineEndpointTokenResult {
        val builder = GetOnlineEndpointTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOnlineEndpointTokenResultToKotlin(getOnlineEndpointTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified private endpoint connection associated with the workspace.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the workspace
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getRegistry(argument: GetRegistryPlainArgs): GetRegistryResult =
        getRegistryResultToKotlin(getRegistryPlain(argument.toJava()).await())

    /**
     * @see [getRegistry].
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getRegistry(registryName: String, resourceGroupName: String):
        GetRegistryResult {
        val argument = GetRegistryPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getRegistryResultToKotlin(getRegistryPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistry].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryPlainArgs].
     * @return null
     */
    public suspend fun getRegistry(argument: suspend GetRegistryPlainArgsBuilder.() -> Unit):
        GetRegistryResult {
        val builder = GetRegistryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryResultToKotlin(getRegistryPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryCodeContainer(argument: GetRegistryCodeContainerPlainArgs):
        GetRegistryCodeContainerResult =
        getRegistryCodeContainerResultToKotlin(getRegistryCodeContainerPlain(argument.toJava()).await())

    /**
     * @see [getRegistryCodeContainer].
     * @param codeName Container name.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryCodeContainer(
        codeName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetRegistryCodeContainerResult {
        val argument = GetRegistryCodeContainerPlainArgs(
            codeName = codeName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getRegistryCodeContainerResultToKotlin(getRegistryCodeContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryCodeContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryCodeContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryCodeContainer(argument: suspend GetRegistryCodeContainerPlainArgsBuilder.() -> Unit):
        GetRegistryCodeContainerResult {
        val builder = GetRegistryCodeContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryCodeContainerResultToKotlin(getRegistryCodeContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryCodeVersion(argument: GetRegistryCodeVersionPlainArgs):
        GetRegistryCodeVersionResult =
        getRegistryCodeVersionResultToKotlin(getRegistryCodeVersionPlain(argument.toJava()).await())

    /**
     * @see [getRegistryCodeVersion].
     * @param codeName Container name.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryCodeVersion(
        codeName: String,
        registryName: String,
        resourceGroupName: String,
        version: String,
    ): GetRegistryCodeVersionResult {
        val argument = GetRegistryCodeVersionPlainArgs(
            codeName = codeName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            version = version,
        )
        return getRegistryCodeVersionResultToKotlin(getRegistryCodeVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryCodeVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryCodeVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryCodeVersion(argument: suspend GetRegistryCodeVersionPlainArgsBuilder.() -> Unit):
        GetRegistryCodeVersionResult {
        val builder = GetRegistryCodeVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryCodeVersionResultToKotlin(getRegistryCodeVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryComponentContainer(argument: GetRegistryComponentContainerPlainArgs):
        GetRegistryComponentContainerResult =
        getRegistryComponentContainerResultToKotlin(getRegistryComponentContainerPlain(argument.toJava()).await())

    /**
     * @see [getRegistryComponentContainer].
     * @param componentName Container name.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryComponentContainer(
        componentName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetRegistryComponentContainerResult {
        val argument = GetRegistryComponentContainerPlainArgs(
            componentName = componentName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getRegistryComponentContainerResultToKotlin(getRegistryComponentContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryComponentContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryComponentContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryComponentContainer(argument: suspend GetRegistryComponentContainerPlainArgsBuilder.() -> Unit):
        GetRegistryComponentContainerResult {
        val builder = GetRegistryComponentContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryComponentContainerResultToKotlin(getRegistryComponentContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryComponentVersion(argument: GetRegistryComponentVersionPlainArgs):
        GetRegistryComponentVersionResult =
        getRegistryComponentVersionResultToKotlin(getRegistryComponentVersionPlain(argument.toJava()).await())

    /**
     * @see [getRegistryComponentVersion].
     * @param componentName Container name.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryComponentVersion(
        componentName: String,
        registryName: String,
        resourceGroupName: String,
        version: String,
    ): GetRegistryComponentVersionResult {
        val argument = GetRegistryComponentVersionPlainArgs(
            componentName = componentName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            version = version,
        )
        return getRegistryComponentVersionResultToKotlin(getRegistryComponentVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryComponentVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryComponentVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryComponentVersion(argument: suspend GetRegistryComponentVersionPlainArgsBuilder.() -> Unit):
        GetRegistryComponentVersionResult {
        val builder = GetRegistryComponentVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryComponentVersionResultToKotlin(getRegistryComponentVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryDataContainer(argument: GetRegistryDataContainerPlainArgs):
        GetRegistryDataContainerResult =
        getRegistryDataContainerResultToKotlin(getRegistryDataContainerPlain(argument.toJava()).await())

    /**
     * @see [getRegistryDataContainer].
     * @param name Container name.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryDataContainer(
        name: String,
        registryName: String,
        resourceGroupName: String,
    ): GetRegistryDataContainerResult {
        val argument = GetRegistryDataContainerPlainArgs(
            name = name,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getRegistryDataContainerResultToKotlin(getRegistryDataContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryDataContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryDataContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryDataContainer(argument: suspend GetRegistryDataContainerPlainArgsBuilder.() -> Unit):
        GetRegistryDataContainerResult {
        val builder = GetRegistryDataContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryDataContainerResultToKotlin(getRegistryDataContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryDataVersion(argument: GetRegistryDataVersionPlainArgs):
        GetRegistryDataVersionResult =
        getRegistryDataVersionResultToKotlin(getRegistryDataVersionPlain(argument.toJava()).await())

    /**
     * @see [getRegistryDataVersion].
     * @param name Container name.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryDataVersion(
        name: String,
        registryName: String,
        resourceGroupName: String,
        version: String,
    ): GetRegistryDataVersionResult {
        val argument = GetRegistryDataVersionPlainArgs(
            name = name,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            version = version,
        )
        return getRegistryDataVersionResultToKotlin(getRegistryDataVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryDataVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryDataVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryDataVersion(argument: suspend GetRegistryDataVersionPlainArgsBuilder.() -> Unit):
        GetRegistryDataVersionResult {
        val builder = GetRegistryDataVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryDataVersionResultToKotlin(getRegistryDataVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryEnvironmentContainer(argument: GetRegistryEnvironmentContainerPlainArgs):
        GetRegistryEnvironmentContainerResult =
        getRegistryEnvironmentContainerResultToKotlin(getRegistryEnvironmentContainerPlain(argument.toJava()).await())

    /**
     * @see [getRegistryEnvironmentContainer].
     * @param environmentName Container name. This is case-sensitive.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryEnvironmentContainer(
        environmentName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetRegistryEnvironmentContainerResult {
        val argument = GetRegistryEnvironmentContainerPlainArgs(
            environmentName = environmentName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getRegistryEnvironmentContainerResultToKotlin(getRegistryEnvironmentContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryEnvironmentContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryEnvironmentContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryEnvironmentContainer(argument: suspend GetRegistryEnvironmentContainerPlainArgsBuilder.() -> Unit):
        GetRegistryEnvironmentContainerResult {
        val builder = GetRegistryEnvironmentContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryEnvironmentContainerResultToKotlin(getRegistryEnvironmentContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryEnvironmentVersion(argument: GetRegistryEnvironmentVersionPlainArgs):
        GetRegistryEnvironmentVersionResult =
        getRegistryEnvironmentVersionResultToKotlin(getRegistryEnvironmentVersionPlain(argument.toJava()).await())

    /**
     * @see [getRegistryEnvironmentVersion].
     * @param environmentName Container name. This is case-sensitive.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier. This is case-sensitive.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryEnvironmentVersion(
        environmentName: String,
        registryName: String,
        resourceGroupName: String,
        version: String,
    ): GetRegistryEnvironmentVersionResult {
        val argument = GetRegistryEnvironmentVersionPlainArgs(
            environmentName = environmentName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            version = version,
        )
        return getRegistryEnvironmentVersionResultToKotlin(getRegistryEnvironmentVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryEnvironmentVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryEnvironmentVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryEnvironmentVersion(argument: suspend GetRegistryEnvironmentVersionPlainArgsBuilder.() -> Unit):
        GetRegistryEnvironmentVersionResult {
        val builder = GetRegistryEnvironmentVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryEnvironmentVersionResultToKotlin(getRegistryEnvironmentVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryModelContainer(argument: GetRegistryModelContainerPlainArgs):
        GetRegistryModelContainerResult =
        getRegistryModelContainerResultToKotlin(getRegistryModelContainerPlain(argument.toJava()).await())

    /**
     * @see [getRegistryModelContainer].
     * @param modelName Container name. This is case-sensitive.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryModelContainer(
        modelName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetRegistryModelContainerResult {
        val argument = GetRegistryModelContainerPlainArgs(
            modelName = modelName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getRegistryModelContainerResultToKotlin(getRegistryModelContainerPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryModelContainer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryModelContainerPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryModelContainer(argument: suspend GetRegistryModelContainerPlainArgsBuilder.() -> Unit):
        GetRegistryModelContainerResult {
        val builder = GetRegistryModelContainerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryModelContainerResultToKotlin(getRegistryModelContainerPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryModelVersion(argument: GetRegistryModelVersionPlainArgs):
        GetRegistryModelVersionResult =
        getRegistryModelVersionResultToKotlin(getRegistryModelVersionPlain(argument.toJava()).await())

    /**
     * @see [getRegistryModelVersion].
     * @param modelName Container name. This is case-sensitive.
     * @param registryName Name of Azure Machine Learning registry. This is case-insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param version Version identifier. This is case-sensitive.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getRegistryModelVersion(
        modelName: String,
        registryName: String,
        resourceGroupName: String,
        version: String,
    ): GetRegistryModelVersionResult {
        val argument = GetRegistryModelVersionPlainArgs(
            modelName = modelName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            version = version,
        )
        return getRegistryModelVersionResultToKotlin(getRegistryModelVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistryModelVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetRegistryModelVersionPlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend
    fun getRegistryModelVersion(argument: suspend GetRegistryModelVersionPlainArgsBuilder.() -> Unit):
        GetRegistryModelVersionResult {
        val builder = GetRegistryModelVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryModelVersionResultToKotlin(getRegistryModelVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Azure Resource Manager resource envelope.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getSchedule(argument: GetSchedulePlainArgs): GetScheduleResult =
        getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())

    /**
     * @see [getSchedule].
     * @param name Schedule name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getSchedule(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetScheduleResult {
        val argument = GetSchedulePlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getScheduleResultToKotlin(getSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetSchedulePlainArgs].
     * @return Azure Resource Manager resource envelope.
     */
    public suspend fun getSchedule(argument: suspend GetSchedulePlainArgsBuilder.() -> Unit):
        GetScheduleResult {
        val builder = GetSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduleResultToKotlin(getSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getServerlessEndpoint(argument: GetServerlessEndpointPlainArgs):
        GetServerlessEndpointResult =
        getServerlessEndpointResultToKotlin(getServerlessEndpointPlain(argument.toJava()).await())

    /**
     * @see [getServerlessEndpoint].
     * @param name Serverless Endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getServerlessEndpoint(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetServerlessEndpointResult {
        val argument = GetServerlessEndpointPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getServerlessEndpointResultToKotlin(getServerlessEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetServerlessEndpointPlainArgs].
     * @return null
     */
    public suspend
    fun getServerlessEndpoint(argument: suspend GetServerlessEndpointPlainArgsBuilder.() -> Unit):
        GetServerlessEndpointResult {
        val builder = GetServerlessEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessEndpointResultToKotlin(getServerlessEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getServerlessEndpointStatus(argument: GetServerlessEndpointStatusPlainArgs):
        GetServerlessEndpointStatusResult =
        getServerlessEndpointStatusResultToKotlin(getServerlessEndpointStatusPlain(argument.toJava()).await())

    /**
     * @see [getServerlessEndpointStatus].
     * @param name Serverless Endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getServerlessEndpointStatus(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetServerlessEndpointStatusResult {
        val argument = GetServerlessEndpointStatusPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getServerlessEndpointStatusResultToKotlin(getServerlessEndpointStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerlessEndpointStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetServerlessEndpointStatusPlainArgs].
     * @return null
     */
    public suspend
    fun getServerlessEndpointStatus(argument: suspend GetServerlessEndpointStatusPlainArgsBuilder.() -> Unit):
        GetServerlessEndpointStatusResult {
        val builder = GetServerlessEndpointStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerlessEndpointStatusResultToKotlin(getServerlessEndpointStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified machine learning workspace.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2018-03-01-preview, 2020-08-01, 2020-09-01-preview, 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return An object that represents a machine learning workspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return An object that represents a machine learning workspace.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return An object that represents a machine learning workspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2021-04-01, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getWorkspaceConnection(argument: GetWorkspaceConnectionPlainArgs):
        GetWorkspaceConnectionResult =
        getWorkspaceConnectionResultToKotlin(getWorkspaceConnectionPlain(argument.toJava()).await())

    /**
     * @see [getWorkspaceConnection].
     * @param connectionName Friendly name of the workspace connection
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun getWorkspaceConnection(
        connectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetWorkspaceConnectionResult {
        val argument = GetWorkspaceConnectionPlainArgs(
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceConnectionResultToKotlin(getWorkspaceConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspaceConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;GetWorkspaceConnectionPlainArgs].
     * @return null
     */
    public suspend
    fun getWorkspaceConnection(argument: suspend GetWorkspaceConnectionPlainArgsBuilder.() -> Unit):
        GetWorkspaceConnectionResult {
        val builder = GetWorkspaceConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceConnectionResultToKotlin(getWorkspaceConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Keys for endpoint authentication.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Keys for endpoint authentication.
     */
    public suspend fun listBatchEndpointKeys(argument: ListBatchEndpointKeysPlainArgs):
        ListBatchEndpointKeysResult =
        listBatchEndpointKeysResultToKotlin(listBatchEndpointKeysPlain(argument.toJava()).await())

    /**
     * @see [listBatchEndpointKeys].
     * @param endpointName Inference Endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Keys for endpoint authentication.
     */
    public suspend fun listBatchEndpointKeys(
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListBatchEndpointKeysResult {
        val argument = ListBatchEndpointKeysPlainArgs(
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listBatchEndpointKeysResultToKotlin(listBatchEndpointKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listBatchEndpointKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListBatchEndpointKeysPlainArgs].
     * @return Keys for endpoint authentication.
     */
    public suspend
    fun listBatchEndpointKeys(argument: suspend ListBatchEndpointKeysPlainArgsBuilder.() -> Unit):
        ListBatchEndpointKeysResult {
        val builder = ListBatchEndpointKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listBatchEndpointKeysResultToKotlin(listBatchEndpointKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets secrets related to Machine Learning compute (storage keys, service credentials, etc).
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Secrets related to a Machine Learning compute. Might differ for every type of compute.
     */
    public suspend fun listComputeKeys(argument: ListComputeKeysPlainArgs): ListComputeKeysResult =
        listComputeKeysResultToKotlin(listComputeKeysPlain(argument.toJava()).await())

    /**
     * @see [listComputeKeys].
     * @param computeName Name of the Azure Machine Learning compute.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Secrets related to a Machine Learning compute. Might differ for every type of compute.
     */
    public suspend fun listComputeKeys(
        computeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListComputeKeysResult {
        val argument = ListComputeKeysPlainArgs(
            computeName = computeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listComputeKeysResultToKotlin(listComputeKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listComputeKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListComputeKeysPlainArgs].
     * @return Secrets related to a Machine Learning compute. Might differ for every type of compute.
     */
    public suspend fun listComputeKeys(argument: suspend ListComputeKeysPlainArgsBuilder.() -> Unit):
        ListComputeKeysResult {
        val builder = ListComputeKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listComputeKeysResultToKotlin(listComputeKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details (e.g IP address, port etc) of all the compute nodes in the compute.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Result of AmlCompute Nodes
     */
    public suspend fun listComputeNodes(argument: ListComputeNodesPlainArgs): ListComputeNodesResult =
        listComputeNodesResultToKotlin(listComputeNodesPlain(argument.toJava()).await())

    /**
     * @see [listComputeNodes].
     * @param computeName Name of the Azure Machine Learning compute.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Result of AmlCompute Nodes
     */
    public suspend fun listComputeNodes(
        computeName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListComputeNodesResult {
        val argument = ListComputeNodesPlainArgs(
            computeName = computeName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listComputeNodesResultToKotlin(listComputeNodesPlain(argument.toJava()).await())
    }

    /**
     * @see [listComputeNodes].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListComputeNodesPlainArgs].
     * @return Result of AmlCompute Nodes
     */
    public suspend
    fun listComputeNodes(argument: suspend ListComputeNodesPlainArgsBuilder.() -> Unit):
        ListComputeNodesResult {
        val builder = ListComputeNodesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listComputeNodesResultToKotlin(listComputeNodesPlain(builtArgument.toJava()).await())
    }

    /**
     * Base definition for datastore secrets.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Base definition for datastore secrets.
     */
    public suspend fun listDatastoreSecrets(argument: ListDatastoreSecretsPlainArgs):
        ListDatastoreSecretsResult =
        listDatastoreSecretsResultToKotlin(listDatastoreSecretsPlain(argument.toJava()).await())

    /**
     * @see [listDatastoreSecrets].
     * @param name Datastore name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Base definition for datastore secrets.
     */
    public suspend fun listDatastoreSecrets(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListDatastoreSecretsResult {
        val argument = ListDatastoreSecretsPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listDatastoreSecretsResultToKotlin(listDatastoreSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDatastoreSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListDatastoreSecretsPlainArgs].
     * @return Base definition for datastore secrets.
     */
    public suspend
    fun listDatastoreSecrets(argument: suspend ListDatastoreSecretsPlainArgsBuilder.() -> Unit):
        ListDatastoreSecretsResult {
        val builder = ListDatastoreSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDatastoreSecretsResultToKotlin(listDatastoreSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun listEndpointKeys(argument: ListEndpointKeysPlainArgs): ListEndpointKeysResult =
        listEndpointKeysResultToKotlin(listEndpointKeysPlain(argument.toJava()).await())

    /**
     * @see [listEndpointKeys].
     * @param endpointName Name of the endpoint resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Azure Machine Learning Workspace Name
     * @return null
     */
    public suspend fun listEndpointKeys(
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListEndpointKeysResult {
        val argument = ListEndpointKeysPlainArgs(
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listEndpointKeysResultToKotlin(listEndpointKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listEndpointKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListEndpointKeysPlainArgs].
     * @return null
     */
    public suspend
    fun listEndpointKeys(argument: suspend ListEndpointKeysPlainArgsBuilder.() -> Unit):
        ListEndpointKeysResult {
        val builder = ListEndpointKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listEndpointKeysResultToKotlin(listEndpointKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * A paginated list of Feature entities.
     * Azure REST API version: 2023-02-01-preview.
     * @param argument null
     * @return A paginated list of Feature entities.
     */
    public suspend
    fun listFeaturesetVersionFeatures(argument: ListFeaturesetVersionFeaturesPlainArgs):
        ListFeaturesetVersionFeaturesResult =
        listFeaturesetVersionFeaturesResultToKotlin(listFeaturesetVersionFeaturesPlain(argument.toJava()).await())

    /**
     * @see [listFeaturesetVersionFeatures].
     * @param name Featureset name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param skip Continuation token for pagination.
     * @param tags Comma-separated list of tag names (and optionally values). Example: tag1,tag2=value2
     * @param version Featureset Version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return A paginated list of Feature entities.
     */
    public suspend fun listFeaturesetVersionFeatures(
        name: String,
        resourceGroupName: String,
        skip: String? = null,
        tags: String? = null,
        version: String,
        workspaceName: String,
    ): ListFeaturesetVersionFeaturesResult {
        val argument = ListFeaturesetVersionFeaturesPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            skip = skip,
            tags = tags,
            version = version,
            workspaceName = workspaceName,
        )
        return listFeaturesetVersionFeaturesResultToKotlin(listFeaturesetVersionFeaturesPlain(argument.toJava()).await())
    }

    /**
     * @see [listFeaturesetVersionFeatures].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListFeaturesetVersionFeaturesPlainArgs].
     * @return A paginated list of Feature entities.
     */
    public suspend
    fun listFeaturesetVersionFeatures(argument: suspend ListFeaturesetVersionFeaturesPlainArgsBuilder.() -> Unit):
        ListFeaturesetVersionFeaturesResult {
        val builder = ListFeaturesetVersionFeaturesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listFeaturesetVersionFeaturesResultToKotlin(listFeaturesetVersionFeaturesPlain(builtArgument.toJava()).await())
    }

    /**
     * A paginated list of FeaturesetJob entities.
     * Azure REST API version: 2023-04-01-preview.
     * Other available API versions: 2023-06-01-preview.
     * @param argument null
     * @return A paginated list of FeaturesetJob entities.
     */
    public suspend
    fun listFeaturesetVersionMaterializationJobs(argument: ListFeaturesetVersionMaterializationJobsPlainArgs):
        ListFeaturesetVersionMaterializationJobsResult =
        listFeaturesetVersionMaterializationJobsResultToKotlin(listFeaturesetVersionMaterializationJobsPlain(argument.toJava()).await())

    /**
     * @see [listFeaturesetVersionMaterializationJobs].
     * @param featureWindowEnd End time of the feature window to filter materialization jobs.
     * @param featureWindowStart Start time of the feature window to filter materialization jobs.
     * @param filters Comma-separated list of tag names (and optionally values). Example: tag1,tag2=value2
     * @param name Container name. This is case-sensitive.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param skip Continuation token for pagination.
     * @param version Version identifier. This is case-sensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return A paginated list of FeaturesetJob entities.
     */
    public suspend fun listFeaturesetVersionMaterializationJobs(
        featureWindowEnd: String? = null,
        featureWindowStart: String? = null,
        filters: String? = null,
        name: String,
        resourceGroupName: String,
        skip: String? = null,
        version: String,
        workspaceName: String,
    ): ListFeaturesetVersionMaterializationJobsResult {
        val argument = ListFeaturesetVersionMaterializationJobsPlainArgs(
            featureWindowEnd = featureWindowEnd,
            featureWindowStart = featureWindowStart,
            filters = filters,
            name = name,
            resourceGroupName = resourceGroupName,
            skip = skip,
            version = version,
            workspaceName = workspaceName,
        )
        return listFeaturesetVersionMaterializationJobsResultToKotlin(listFeaturesetVersionMaterializationJobsPlain(argument.toJava()).await())
    }

    /**
     * @see [listFeaturesetVersionMaterializationJobs].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListFeaturesetVersionMaterializationJobsPlainArgs].
     * @return A paginated list of FeaturesetJob entities.
     */
    public suspend
    fun listFeaturesetVersionMaterializationJobs(argument: suspend ListFeaturesetVersionMaterializationJobsPlainArgsBuilder.() -> Unit):
        ListFeaturesetVersionMaterializationJobsResult {
        val builder = ListFeaturesetVersionMaterializationJobsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listFeaturesetVersionMaterializationJobsResultToKotlin(listFeaturesetVersionMaterializationJobsPlain(builtArgument.toJava()).await())
    }

    /**
     * Keys for endpoint authentication.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return Keys for endpoint authentication.
     */
    public suspend fun listOnlineEndpointKeys(argument: ListOnlineEndpointKeysPlainArgs):
        ListOnlineEndpointKeysResult =
        listOnlineEndpointKeysResultToKotlin(listOnlineEndpointKeysPlain(argument.toJava()).await())

    /**
     * @see [listOnlineEndpointKeys].
     * @param endpointName Online Endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Keys for endpoint authentication.
     */
    public suspend fun listOnlineEndpointKeys(
        endpointName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListOnlineEndpointKeysResult {
        val argument = ListOnlineEndpointKeysPlainArgs(
            endpointName = endpointName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listOnlineEndpointKeysResultToKotlin(listOnlineEndpointKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listOnlineEndpointKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListOnlineEndpointKeysPlainArgs].
     * @return Keys for endpoint authentication.
     */
    public suspend
    fun listOnlineEndpointKeys(argument: suspend ListOnlineEndpointKeysPlainArgsBuilder.() -> Unit):
        ListOnlineEndpointKeysResult {
        val builder = ListOnlineEndpointKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listOnlineEndpointKeysResultToKotlin(listOnlineEndpointKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Keys for endpoint authentication.
     * Azure REST API version: 2023-08-01-preview.
     * Other available API versions: 2024-01-01-preview.
     * @param argument null
     * @return Keys for endpoint authentication.
     */
    public suspend fun listServerlessEndpointKeys(argument: ListServerlessEndpointKeysPlainArgs):
        ListServerlessEndpointKeysResult =
        listServerlessEndpointKeysResultToKotlin(listServerlessEndpointKeysPlain(argument.toJava()).await())

    /**
     * @see [listServerlessEndpointKeys].
     * @param name Serverless Endpoint name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return Keys for endpoint authentication.
     */
    public suspend fun listServerlessEndpointKeys(
        name: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListServerlessEndpointKeysResult {
        val argument = ListServerlessEndpointKeysPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listServerlessEndpointKeysResultToKotlin(listServerlessEndpointKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listServerlessEndpointKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListServerlessEndpointKeysPlainArgs].
     * @return Keys for endpoint authentication.
     */
    public suspend
    fun listServerlessEndpointKeys(argument: suspend ListServerlessEndpointKeysPlainArgsBuilder.() -> Unit):
        ListServerlessEndpointKeysResult {
        val builder = ListServerlessEndpointKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listServerlessEndpointKeysResultToKotlin(listServerlessEndpointKeysPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-08-01-preview, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend
    fun listWorkspaceConnectionSecrets(argument: ListWorkspaceConnectionSecretsPlainArgs):
        ListWorkspaceConnectionSecretsResult =
        listWorkspaceConnectionSecretsResultToKotlin(listWorkspaceConnectionSecretsPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceConnectionSecrets].
     * @param connectionName Friendly name of the workspace connection
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun listWorkspaceConnectionSecrets(
        connectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): ListWorkspaceConnectionSecretsResult {
        val argument = ListWorkspaceConnectionSecretsPlainArgs(
            connectionName = connectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listWorkspaceConnectionSecretsResultToKotlin(listWorkspaceConnectionSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceConnectionSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListWorkspaceConnectionSecretsPlainArgs].
     * @return null
     */
    public suspend
    fun listWorkspaceConnectionSecrets(argument: suspend ListWorkspaceConnectionSecretsPlainArgsBuilder.() -> Unit):
        ListWorkspaceConnectionSecretsResult {
        val builder = ListWorkspaceConnectionSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceConnectionSecretsResultToKotlin(listWorkspaceConnectionSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists all the keys associated with this workspace. This includes keys for the storage account, app insights and password for container registry
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2018-03-01-preview, 2020-08-01, 2020-09-01-preview, 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun listWorkspaceKeys(argument: ListWorkspaceKeysPlainArgs):
        ListWorkspaceKeysResult =
        listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceKeys].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun listWorkspaceKeys(resourceGroupName: String, workspaceName: String):
        ListWorkspaceKeysResult {
        val argument = ListWorkspaceKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListWorkspaceKeysPlainArgs].
     * @return null
     */
    public suspend
    fun listWorkspaceKeys(argument: suspend ListWorkspaceKeysPlainArgsBuilder.() -> Unit):
        ListWorkspaceKeysResult {
        val builder = ListWorkspaceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * return notebook access token and refresh token
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend
    fun listWorkspaceNotebookAccessToken(argument: ListWorkspaceNotebookAccessTokenPlainArgs):
        ListWorkspaceNotebookAccessTokenResult =
        listWorkspaceNotebookAccessTokenResultToKotlin(listWorkspaceNotebookAccessTokenPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceNotebookAccessToken].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun listWorkspaceNotebookAccessToken(
        resourceGroupName: String,
        workspaceName: String,
    ): ListWorkspaceNotebookAccessTokenResult {
        val argument = ListWorkspaceNotebookAccessTokenPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listWorkspaceNotebookAccessTokenResultToKotlin(listWorkspaceNotebookAccessTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceNotebookAccessToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListWorkspaceNotebookAccessTokenPlainArgs].
     * @return null
     */
    public suspend
    fun listWorkspaceNotebookAccessToken(argument: suspend ListWorkspaceNotebookAccessTokenPlainArgsBuilder.() -> Unit):
        ListWorkspaceNotebookAccessTokenResult {
        val builder = ListWorkspaceNotebookAccessTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceNotebookAccessTokenResultToKotlin(listWorkspaceNotebookAccessTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * List keys of a notebook.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend fun listWorkspaceNotebookKeys(argument: ListWorkspaceNotebookKeysPlainArgs):
        ListWorkspaceNotebookKeysResult =
        listWorkspaceNotebookKeysResultToKotlin(listWorkspaceNotebookKeysPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceNotebookKeys].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun listWorkspaceNotebookKeys(resourceGroupName: String, workspaceName: String):
        ListWorkspaceNotebookKeysResult {
        val argument = ListWorkspaceNotebookKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listWorkspaceNotebookKeysResultToKotlin(listWorkspaceNotebookKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceNotebookKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListWorkspaceNotebookKeysPlainArgs].
     * @return null
     */
    public suspend
    fun listWorkspaceNotebookKeys(argument: suspend ListWorkspaceNotebookKeysPlainArgsBuilder.() -> Unit):
        ListWorkspaceNotebookKeysResult {
        val builder = ListWorkspaceNotebookKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceNotebookKeysResultToKotlin(listWorkspaceNotebookKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * List storage account keys of a workspace.
     * Azure REST API version: 2023-04-01.
     * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
     * @param argument null
     * @return null
     */
    public suspend
    fun listWorkspaceStorageAccountKeys(argument: ListWorkspaceStorageAccountKeysPlainArgs):
        ListWorkspaceStorageAccountKeysResult =
        listWorkspaceStorageAccountKeysResultToKotlin(listWorkspaceStorageAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceStorageAccountKeys].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName Name of Azure Machine Learning workspace.
     * @return null
     */
    public suspend fun listWorkspaceStorageAccountKeys(
        resourceGroupName: String,
        workspaceName: String,
    ): ListWorkspaceStorageAccountKeysResult {
        val argument = ListWorkspaceStorageAccountKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listWorkspaceStorageAccountKeysResultToKotlin(listWorkspaceStorageAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceStorageAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearningservices&#46;kotlin&#46;inputs&#46;ListWorkspaceStorageAccountKeysPlainArgs].
     * @return null
     */
    public suspend
    fun listWorkspaceStorageAccountKeys(argument: suspend ListWorkspaceStorageAccountKeysPlainArgsBuilder.() -> Unit):
        ListWorkspaceStorageAccountKeysResult {
        val builder = ListWorkspaceStorageAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceStorageAccountKeysResultToKotlin(listWorkspaceStorageAccountKeysPlain(builtArgument.toJava()).await())
    }
}
