@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedNetworkSettingsRule].
 */
@PulumiTagMarker
public class ManagedNetworkSettingsRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedNetworkSettingsRuleArgs = ManagedNetworkSettingsRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedNetworkSettingsRuleArgsBuilder.() -> Unit) {
        val builder = ManagedNetworkSettingsRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedNetworkSettingsRule {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedNetworkSettingsRule(builtJavaResource)
    }
}

/**
 * Outbound Rule Basic Resource for the managed network of a machine learning workspace.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate ManagedNetworkSettingsRule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetworkSettingsRule = new AzureNative.MachineLearningServices.ManagedNetworkSettingsRule("managedNetworkSettingsRule", new()
 *     {
 *         Properties = new AzureNative.MachineLearningServices.Inputs.FqdnOutboundRuleArgs
 *         {
 *             Category = "UserDefined",
 *             Destination = "some_string",
 *             Status = "Active",
 *             Type = "FQDN",
 *         },
 *         ResourceGroupName = "test-rg",
 *         RuleName = "some_string",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewManagedNetworkSettingsRule(ctx, "managedNetworkSettingsRule", &machinelearningservices.ManagedNetworkSettingsRuleArgs{
 * 			Properties: machinelearningservices.FqdnOutboundRule{
 * 				Category:    "UserDefined",
 * 				Destination: "some_string",
 * 				Status:      "Active",
 * 				Type:        "FQDN",
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			RuleName:          pulumi.String("some_string"),
 * 			WorkspaceName:     pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRule;
 * import com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetworkSettingsRule = new ManagedNetworkSettingsRule("managedNetworkSettingsRule", ManagedNetworkSettingsRuleArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("category", "UserDefined"),
 *                 Map.entry("destination", "some_string"),
 *                 Map.entry("status", "Active"),
 *                 Map.entry("type", "FQDN")
 *             ))
 *             .resourceGroupName("test-rg")
 *             .ruleName("some_string")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ManagedNetworkSettingsRule some_string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/outboundRules/{ruleName}
 * ```
 */
public class ManagedNetworkSettingsRule internal constructor(
    override val javaResource:
    com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRule,
) : KotlinCustomResource(javaResource, ManagedNetworkSettingsRuleMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Outbound Rule for the managed network of a machine learning workspace.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedNetworkSettingsRuleMapper : ResourceMapper<ManagedNetworkSettingsRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRule::class == javaResource::class

    override fun map(javaResource: Resource): ManagedNetworkSettingsRule =
        ManagedNetworkSettingsRule(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRule,
        )
}

/**
 * @see [ManagedNetworkSettingsRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedNetworkSettingsRule].
 */
public suspend fun managedNetworkSettingsRule(
    name: String,
    block: suspend ManagedNetworkSettingsRuleResourceBuilder.() -> Unit,
):
    ManagedNetworkSettingsRule {
    val builder = ManagedNetworkSettingsRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedNetworkSettingsRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedNetworkSettingsRule(name: String): ManagedNetworkSettingsRule {
    val builder = ManagedNetworkSettingsRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
