@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Outbound Rule Basic Resource for the managed network of a machine learning workspace.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate ManagedNetworkSettingsRule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetworkSettingsRule = new AzureNative.MachineLearningServices.ManagedNetworkSettingsRule("managedNetworkSettingsRule", new()
 *     {
 *         Properties = new AzureNative.MachineLearningServices.Inputs.FqdnOutboundRuleArgs
 *         {
 *             Category = "UserDefined",
 *             Destination = "some_string",
 *             Status = "Active",
 *             Type = "FQDN",
 *         },
 *         ResourceGroupName = "test-rg",
 *         RuleName = "some_string",
 *         WorkspaceName = "aml-workspace-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewManagedNetworkSettingsRule(ctx, "managedNetworkSettingsRule", &machinelearningservices.ManagedNetworkSettingsRuleArgs{
 * 			Properties: machinelearningservices.FqdnOutboundRule{
 * 				Category:    "UserDefined",
 * 				Destination: "some_string",
 * 				Status:      "Active",
 * 				Type:        "FQDN",
 * 			},
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			RuleName:          pulumi.String("some_string"),
 * 			WorkspaceName:     pulumi.String("aml-workspace-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRule;
 * import com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetworkSettingsRule = new ManagedNetworkSettingsRule("managedNetworkSettingsRule", ManagedNetworkSettingsRuleArgs.builder()
 *             .properties(Map.ofEntries(
 *                 Map.entry("category", "UserDefined"),
 *                 Map.entry("destination", "some_string"),
 *                 Map.entry("status", "Active"),
 *                 Map.entry("type", "FQDN")
 *             ))
 *             .resourceGroupName("test-rg")
 *             .ruleName("some_string")
 *             .workspaceName("aml-workspace-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ManagedNetworkSettingsRule some_string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/outboundRules/{ruleName}
 * ```
 * @property properties Outbound Rule for the managed network of a machine learning workspace.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleName Name of the workspace managed network outbound rule
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ManagedNetworkSettingsRuleArgs(
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRuleArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRuleArgs =
        com.pulumi.azurenative.machinelearningservices.ManagedNetworkSettingsRuleArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedNetworkSettingsRuleArgs].
 */
@PulumiTagMarker
public class ManagedNetworkSettingsRuleArgsBuilder internal constructor() {
    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("simyjvcpgnjnmexp")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("reebimfbobapoflp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the workspace managed network outbound rule
     */
    @JvmName("ufdgvselpqjehklj")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("nlqdfgguhdcrbheq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Outbound Rule for the managed network of a machine learning workspace.
     */
    @JvmName("ppmbkrvckrtlrgvb")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jnkqjvtkkpaninxj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the workspace managed network outbound rule
     */
    @JvmName("ntuphntglvujhtyd")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("cqlxbiujbohbnejh")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ManagedNetworkSettingsRuleArgs = ManagedNetworkSettingsRuleArgs(
        properties = properties,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        workspaceName = workspaceName,
    )
}
