@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MarketplaceSubscriptionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.MarketplaceSubscriptionResponse.Companion.toKotlin as marketplaceSubscriptionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MarketplaceSubscription].
 */
@PulumiTagMarker
public class MarketplaceSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MarketplaceSubscriptionArgs = MarketplaceSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MarketplaceSubscriptionArgsBuilder.() -> Unit) {
        val builder = MarketplaceSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MarketplaceSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.MarketplaceSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MarketplaceSubscription(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Marketplace Subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var marketplaceSubscription = new AzureNative.MachineLearningServices.MarketplaceSubscription("marketplaceSubscription", new()
 *     {
 *         MarketplaceSubscriptionProperties = new AzureNative.MachineLearningServices.Inputs.MarketplaceSubscriptionArgs
 *         {
 *             ModelId = "string",
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMarketplaceSubscription(ctx, "marketplaceSubscription", &machinelearningservices.MarketplaceSubscriptionArgs{
 * 			MarketplaceSubscriptionProperties: &machinelearningservices.MarketplaceSubscriptionTypeArgs{
 * 				ModelId: pulumi.String("string"),
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MarketplaceSubscription;
 * import com.pulumi.azurenative.machinelearningservices.MarketplaceSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var marketplaceSubscription = new MarketplaceSubscription("marketplaceSubscription", MarketplaceSubscriptionArgs.builder()
 *             .marketplaceSubscriptionProperties(Map.of("modelId", "string"))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:MarketplaceSubscription string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/marketplaceSubscriptions/{name}
 * ```
 */
public class MarketplaceSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.MarketplaceSubscription,
) : KotlinCustomResource(javaResource, MarketplaceSubscriptionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val marketplaceSubscriptionProperties: Output<MarketplaceSubscriptionResponse>
        get() = javaResource.marketplaceSubscriptionProperties().applyValue({ args0 ->
            args0.let({ args0 -> marketplaceSubscriptionResponseToKotlin(args0) })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MarketplaceSubscriptionMapper : ResourceMapper<MarketplaceSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.MarketplaceSubscription::class == javaResource::class

    override fun map(javaResource: Resource): MarketplaceSubscription =
        MarketplaceSubscription(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.MarketplaceSubscription,
        )
}

/**
 * @see [MarketplaceSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MarketplaceSubscription].
 */
public suspend fun marketplaceSubscription(
    name: String,
    block: suspend MarketplaceSubscriptionResourceBuilder.() -> Unit,
): MarketplaceSubscription {
    val builder = MarketplaceSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MarketplaceSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun marketplaceSubscription(name: String): MarketplaceSubscription {
    val builder = MarketplaceSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
