@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.MarketplaceSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Marketplace Subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var marketplaceSubscription = new AzureNative.MachineLearningServices.MarketplaceSubscription("marketplaceSubscription", new()
 *     {
 *         MarketplaceSubscriptionProperties = new AzureNative.MachineLearningServices.Inputs.MarketplaceSubscriptionArgs
 *         {
 *             ModelId = "string",
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMarketplaceSubscription(ctx, "marketplaceSubscription", &machinelearningservices.MarketplaceSubscriptionArgs{
 * 			MarketplaceSubscriptionProperties: &machinelearningservices.MarketplaceSubscriptionTypeArgs{
 * 				ModelId: pulumi.String("string"),
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MarketplaceSubscription;
 * import com.pulumi.azurenative.machinelearningservices.MarketplaceSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var marketplaceSubscription = new MarketplaceSubscription("marketplaceSubscription", MarketplaceSubscriptionArgs.builder()
 *             .marketplaceSubscriptionProperties(Map.of("modelId", "string"))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:MarketplaceSubscription string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/marketplaceSubscriptions/{name}
 * ```
 * @property marketplaceSubscriptionProperties [Required] Additional attributes of the entity.
 * @property name Marketplace Subscription name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class MarketplaceSubscriptionArgs(
    public val marketplaceSubscriptionProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.MarketplaceSubscriptionArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.MarketplaceSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.MarketplaceSubscriptionArgs =
        com.pulumi.azurenative.machinelearningservices.MarketplaceSubscriptionArgs.builder()
            .marketplaceSubscriptionProperties(
                marketplaceSubscriptionProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MarketplaceSubscriptionArgs].
 */
@PulumiTagMarker
public class MarketplaceSubscriptionArgsBuilder internal constructor() {
    private var marketplaceSubscriptionProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.MarketplaceSubscriptionArgs>? =
        null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("uskhxnlnjvssunwv")
    public suspend
    fun marketplaceSubscriptionProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.MarketplaceSubscriptionArgs>) {
        this.marketplaceSubscriptionProperties = value
    }

    /**
     * @param value Marketplace Subscription name.
     */
    @JvmName("njfiyolyrtotkiae")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lhsinvwtimqpijqe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("tgfinewjsxqkfwmj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("fpqpqqeobxhprmkc")
    public suspend
    fun marketplaceSubscriptionProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.MarketplaceSubscriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceSubscriptionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("tdfagadqlbhimbiq")
    public suspend
    fun marketplaceSubscriptionProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.MarketplaceSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.MarketplaceSubscriptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.marketplaceSubscriptionProperties = mapped
    }

    /**
     * @param value Marketplace Subscription name.
     */
    @JvmName("jvoelioihfstioig")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kxoktlmoslchupmd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("gitqetuoussnktsp")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): MarketplaceSubscriptionArgs = MarketplaceSubscriptionArgs(
        marketplaceSubscriptionProperties = marketplaceSubscriptionProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
