@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ModelContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Model Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modelContainer = new AzureNative.MachineLearningServices.ModelContainer("modelContainer", new()
 *     {
 *         ModelContainerProperties = new AzureNative.MachineLearningServices.Inputs.ModelContainerArgs
 *         {
 *             Description = "Model container description",
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         Name = "testContainer",
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspace123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewModelContainer(ctx, "modelContainer", &machinelearningservices.ModelContainerArgs{
 * 			ModelContainerProperties: &machinelearningservices.ModelContainerTypeArgs{
 * 				Description: pulumi.String("Model container description"),
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("testContainer"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspace123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ModelContainer;
 * import com.pulumi.azurenative.machinelearningservices.ModelContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modelContainer = new ModelContainer("modelContainer", ModelContainerArgs.builder()
 *             .modelContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "Model container description"),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *             ))
 *             .name("testContainer")
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspace123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ModelContainer testContainer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/models/{name}
 * ```
 * @property modelContainerProperties [Required] Additional attributes of the entity.
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ModelContainerArgs(
    public val modelContainerProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ModelContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.ModelContainerArgs =
        com.pulumi.azurenative.machinelearningservices.ModelContainerArgs.builder()
            .modelContainerProperties(
                modelContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelContainerArgs].
 */
@PulumiTagMarker
public class ModelContainerArgsBuilder internal constructor() {
    private var modelContainerProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgs>? =
        null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("pitooteuonxicykr")
    public suspend
    fun modelContainerProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgs>) {
        this.modelContainerProperties = value
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("sbheyohtqdcremqx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sjlcrtvwvurovlxg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("jxwixipglxdrqogj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("aloaalkvfcsqmwma")
    public suspend
    fun modelContainerProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("iaqsuntvtbccakyk")
    public suspend
    fun modelContainerProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.modelContainerProperties = mapped
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("pnjwkjeeyvouxptr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("laeoabqqeehiejbx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("jqjsdgjtsqbtxheu")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ModelContainerArgs = ModelContainerArgs(
        modelContainerProperties = modelContainerProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
