@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Registry string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}
 * ```
 * @property identity Managed service identity (system assigned and/or user assigned identities)
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
 * @property location The geo-location where the resource lives
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property registryProperties [Required] Additional attributes of the entity.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku Sku details required for ARM contract for Autoscaling.
 * @property tags Resource tags.
 */
public data class RegistryArgs(
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val registryProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RegistryArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .registryProperties(
                registryProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RegistryArgs].
 */
@PulumiTagMarker
public class RegistryArgsBuilder internal constructor() {
    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var registryName: Output<String>? = null

    private var registryProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RegistryArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("wnxojgsnbeqmtpiq")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("yghlmfqaeyyyolgs")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("scwyxisybjmpwomt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("lekkskfhatoaisms")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("hnyeptcutyrwbqcu")
    public suspend
    fun registryProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RegistryArgs>) {
        this.registryProperties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sssbcssfklmjhlfr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("cyvpgkjninvaexcs")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fwuueaxjrfijfees")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("nggnepmqtatybcbf")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed service identity (system assigned and/or user assigned identities)
     */
    @JvmName("femrmbodktekunbt")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
     */
    @JvmName("iywssooictgjyswk")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("oauwflxndobnbmpf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("hwpwowgnnxjtditd")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("hirwbbcphaxwnqxk")
    public suspend
    fun registryProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RegistryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("elojghfdxoifnlqf")
    public suspend
    fun registryProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RegistryArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.RegistryArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.registryProperties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jsblwgdtwkahasoy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("qcibekhietnqkjrj")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku details required for ARM contract for Autoscaling.
     */
    @JvmName("cnhvfjjlewihuuwx")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mjyiafqtrjfplnll")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("shsnjaluxsgulrma")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RegistryArgs = RegistryArgs(
        identity = identity,
        kind = kind,
        location = location,
        registryName = registryName,
        registryProperties = registryProperties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
